/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.map.querycache.subscriber.TestClientSubscriberContext;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EventLostEvent;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.listener.EventLostListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheRecoveryUponEventLossTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    @Test
    public void testForceConsistency() {
        String mapName = ClientQueryCacheRecoveryUponEventLossTest.randomMapName((String)"map");
        String queryCacheName = ClientQueryCacheRecoveryUponEventLossTest.randomMapName((String)"cache");
        Config config = new Config();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "1");
        this.factory.newHazelcastInstance(config);
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(queryCacheName);
        queryCacheConfig.setBatchSize(1111);
        queryCacheConfig.setDelaySeconds(3);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(mapName);
        int count = 30;
        this.setTestSequencer(map, 9);
        final QueryCache queryCache = map.getQueryCache(queryCacheName, (Predicate)new SqlPredicate("this > 20"), true);
        queryCache.addEntryListener((MapListener)new EventLostListener(){

            public void eventLost(EventLostEvent event) {
                queryCache.tryRecover();
            }
        }, false);
        for (int i = 0; i < count; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientQueryCacheRecoveryUponEventLossTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)9L, (long)queryCache.size());
            }
        });
    }

    private void setTestSequencer(IMap map, int eventCount) {
        ClientMapProxy proxy = (ClientMapProxy)map;
        ClientQueryCacheContext queryCacheContext = proxy.getQueryCacheContext();
        queryCacheContext.setSubscriberContext((SubscriberContext)new TestClientSubscriberContext((QueryCacheContext)queryCacheContext, eventCount, true));
    }
}

