/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class})
public class ClientQueryCacheSimpleStressTest
extends HazelcastTestSupport {
    private final String mapName = ClientQueryCacheSimpleStressTest.randomString();
    private final String cacheName = ClientQueryCacheSimpleStressTest.randomString();
    private final ClientConfig config = new ClientConfig();
    private final int numberOfElementsToPut = 10000;
    private HazelcastInstance instance;

    @Before
    public void setUp() {
        Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        this.setQueryCacheConfig();
        this.instance = HazelcastClient.newHazelcastClient((ClientConfig)this.config);
    }

    private void setQueryCacheConfig() {
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(this.cacheName);
        queryCacheConfig.setBufferSize(30).setDelaySeconds(2).setBatchSize(2).setPopulate(true).getPredicateConfig().setImplementation((Predicate)TruePredicate.INSTANCE);
        this.config.addQueryCacheConfig(this.mapName, queryCacheConfig);
    }

    @After
    public void tearDown() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testStress() throws Exception {
        final IMap map = this.instance.getMap(this.mapName);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    map.put((Object)i, (Object)i);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        QueryCache queryCache = map.getQueryCache(this.cacheName, (Predicate)TruePredicate.INSTANCE, true);
        thread.join();
        this.assertQueryCacheSizeEventually(10000, queryCache);
    }

    private void assertQueryCacheSizeEventually(final int expected, final QueryCache queryCache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)expected, (long)queryCache.size());
            }
        };
        ClientQueryCacheSimpleStressTest.assertTrueEventually((AssertTask)task);
    }
}

