/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.querycache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.IMap;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientQueryCacheTest
extends HazelcastTestSupport {
    private static final Predicate<Integer, Integer> TRUE_PREDICATE = TruePredicate.INSTANCE;
    private static TestHazelcastFactory factory = new TestHazelcastFactory();

    @BeforeClass
    public static void setUp() throws Exception {
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
        factory.newHazelcastInstance();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        factory.shutdownAll();
    }

    @Test
    public void testQueryCache_whenIncludeValueEnabled() {
        boolean includeValue = true;
        this.testQueryCache(includeValue);
    }

    @Test
    public void testQueryCache_whenIncludeValueDisabled() {
        boolean includeValue = false;
        this.testQueryCache(includeValue);
    }

    @Test
    public void testQueryCache_whenInitialPopulationEnabled() {
        int numberOfElementsToBePutToIMap;
        boolean enableInitialPopulation = true;
        int expectedSizeOfQueryCache = numberOfElementsToBePutToIMap = 1000;
        this.testWithInitialPopulation(enableInitialPopulation, expectedSizeOfQueryCache, numberOfElementsToBePutToIMap);
    }

    @Test
    public void testQueryCache_whenInitialPopulationDisabled() {
        boolean enableInitialPopulation = false;
        int numberOfElementsToBePutToIMap = 1000;
        int expectedSizeOfQueryCache = 0;
        this.testWithInitialPopulation(enableInitialPopulation, expectedSizeOfQueryCache, numberOfElementsToBePutToIMap);
    }

    @Test
    public void testQueryCache_withLocalListener() {
        String mapName = ClientQueryCacheTest.randomString();
        String queryCacheName = ClientQueryCacheTest.randomString();
        HazelcastInstance client = factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        for (int i = 0; i < 30; ++i) {
            map.put((Object)i, (Object)i);
        }
        final AtomicInteger countAddEvent = new AtomicInteger();
        final AtomicInteger countRemoveEvent = new AtomicInteger();
        final QueryCache queryCache = map.getQueryCache(queryCacheName, (MapListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                countAddEvent.incrementAndGet();
            }

            public void entryRemoved(EntryEvent event) {
                countRemoveEvent.incrementAndGet();
            }
        }, (Predicate)new SqlPredicate("this > 20"), true);
        for (int i = 0; i < 30; ++i) {
            map.remove((Object)i);
        }
        ClientQueryCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)queryCache.size());
            }
        });
        ClientQueryCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((String)"Count of add events wrong!", (long)9L, (long)countAddEvent.get());
            }
        });
        ClientQueryCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((String)"Count of remove events wrong!", (long)9L, (long)countRemoveEvent.get());
            }
        });
    }

    @Test
    public void testQueryCacheCleared_afterCalling_IMap_evictAll() {
        String cacheName = ClientQueryCacheTest.randomString();
        final IMap<Integer, Integer> map = this.getMap();
        QueryCache queryCache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        IFunction evictAll = new IFunction(){

            public Object apply(Object ignored) {
                map.evictAll();
                return null;
            }
        };
        this.assertQueryCacheSizeEventually(0, evictAll, queryCache);
    }

    @Test
    public void testQueryCacheCleared_afterCalling_IMap_clear() {
        String cacheName = ClientQueryCacheTest.randomString();
        final IMap<Integer, Integer> map = this.getMap();
        QueryCache queryCache = map.getQueryCache(cacheName, TRUE_PREDICATE, false);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        IFunction clear = new IFunction(){

            public Object apply(Object ignored) {
                map.clear();
                return null;
            }
        };
        this.assertQueryCacheSizeEventually(0, clear, queryCache);
    }

    @Test
    public void testDestroy_emptiesQueryCache() {
        int entryCount = 1000;
        final CountDownLatch numberOfAddEvents = new CountDownLatch(entryCount);
        String cacheName = ClientQueryCacheTest.randomString();
        IMap<Integer, Integer> map = this.getMap();
        QueryCache queryCache = map.getQueryCache(cacheName, (MapListener)new EntryAddedListener<Integer, Integer>(){

            public void entryAdded(EntryEvent<Integer, Integer> event) {
                numberOfAddEvents.countDown();
            }
        }, TRUE_PREDICATE, false);
        for (int i = 0; i < entryCount; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientQueryCacheTest.assertOpenEventually((CountDownLatch)numberOfAddEvents);
        queryCache.destroy();
        Assert.assertEquals((long)0L, (long)queryCache.size());
    }

    private void testWithInitialPopulation(boolean enableInitialPopulation, int expectedSize, int numberOfElementsToPut) {
        String mapName = ClientQueryCacheTest.randomString();
        String cacheName = ClientQueryCacheTest.randomName();
        ClientConfig config = this.getConfig(cacheName, enableInitialPopulation, mapName);
        HazelcastInstance client = factory.newHazelcastClient(config);
        IMap map = client.getMap(mapName);
        for (int i = 0; i < numberOfElementsToPut; ++i) {
            map.put((Object)i, (Object)i);
        }
        QueryCache queryCache = map.getQueryCache(cacheName, TRUE_PREDICATE, true);
        Assert.assertEquals((long)expectedSize, (long)queryCache.size());
    }

    private void testQueryCache(boolean includeValue) {
        String mapName = ClientQueryCacheTest.randomString();
        String queryCacheName = ClientQueryCacheTest.randomString();
        HazelcastInstance client = factory.newHazelcastClient();
        IMap map = client.getMap(mapName);
        for (int i = 0; i < 50; ++i) {
            map.put((Object)i, (Object)i);
        }
        SqlPredicate predicate = new SqlPredicate("this > 5 AND this < 100");
        QueryCache cache = map.getQueryCache(queryCacheName, (Predicate)predicate, includeValue);
        for (int i = 50; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
        int expected = 94;
        this.assertQueryCacheSize(expected, cache);
    }

    private ClientConfig getConfig(String queryCacheName, boolean enableInitialPopulation, String mapName) {
        QueryCacheConfig queryCacheConfig = new QueryCacheConfig(queryCacheName);
        queryCacheConfig.setPopulate(enableInitialPopulation).getPredicateConfig().setImplementation((Predicate)TruePredicate.INSTANCE);
        return this.addConfig(queryCacheConfig, mapName);
    }

    private ClientConfig addConfig(QueryCacheConfig queryCacheConfig, String mapName) {
        ClientConfig clientConfig = new ClientConfig();
        Map queryCacheConfigs = clientConfig.getQueryCacheConfigs();
        HashMap<String, QueryCacheConfig> queryCacheConfigMap = (HashMap<String, QueryCacheConfig>)queryCacheConfigs.get(mapName);
        if (queryCacheConfigMap == null) {
            queryCacheConfigMap = new HashMap<String, QueryCacheConfig>();
            queryCacheConfigs.put(mapName, queryCacheConfigMap);
        }
        queryCacheConfigMap.put(queryCacheConfig.getName(), queryCacheConfig);
        return clientConfig;
    }

    private IMap<Integer, Integer> getMap() {
        String mapName = ClientQueryCacheTest.randomString();
        HazelcastInstance client = factory.newHazelcastClient();
        return client.getMap(mapName);
    }

    private void assertQueryCacheSize(final int expected, final QueryCache cache) {
        ClientQueryCacheTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)expected, (long)cache.size());
            }
        }, (long)20L);
    }

    private void assertQueryCacheSizeEventually(final int expected, final IFunction<?, ?> function, final QueryCache queryCache) {
        AssertTask task = new AssertTask(){

            public void run() throws Exception {
                if (function != null) {
                    function.apply(null);
                }
                Assert.assertEquals((long)expected, (long)queryCache.size());
            }
        };
        ClientQueryCacheTest.assertTrueEventually((AssertTask)task);
    }
}

