/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce;

import com.hazelcast.client.mapreduce.AbstractClientMapReduceJobTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ISet;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.ListSetMapReduceTest;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class ClientListSetMapReduceTest
extends AbstractClientMapReduceJobTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=60000L)
    public void testMapReduceWithList() throws Exception {
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h1);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h2);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h3);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        int expectedResult = 0;
        IList list = h1.getList("default");
        for (int o = 0; o < 100; ++o) {
            list.add((Object)o);
            expectedResult += o;
        }
        JobTracker jobTracker = client.getJobTracker("default");
        Job job = jobTracker.newJob(KeyValueSource.fromList((IList)list));
        JobCompletableFuture ICompletableFuture2 = job.chunkSize(10).mapper((Mapper)new ListSetMapReduceTest.ListSetMapper()).combiner((CombinerFactory)new ListSetMapReduceTest.ListSetCombinerFactory()).reducer((ReducerFactory)new ListSetMapReduceTest.ListSetReducerFactory()).submit();
        Map result = (Map)ICompletableFuture2.get();
        Assert.assertEquals((long)1L, (long)result.size());
        boolean count = false;
        for (Map.Entry entry : result.entrySet()) {
            Assert.assertEquals((Object)list.getName(), entry.getKey());
            Assert.assertEquals((long)expectedResult, (long)((Integer)entry.getValue()).intValue());
        }
    }

    @Test(timeout=60000L)
    public void testMapReduceWithSet() throws Exception {
        Config config = this.buildConfig();
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance h3 = this.hazelcastFactory.newHazelcastInstance(config);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h1);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h2);
        ClientListSetMapReduceTest.assertClusterSizeEventually((int)3, (HazelcastInstance)h3);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        int expectedResult = 0;
        ISet set = h1.getSet("default");
        for (int o = 0; o < 100; ++o) {
            set.add((Object)o);
            expectedResult += o;
        }
        JobTracker jobTracker = client.getJobTracker("default");
        Job job = jobTracker.newJob(KeyValueSource.fromSet((ISet)set));
        JobCompletableFuture ICompletableFuture2 = job.chunkSize(10).mapper((Mapper)new ListSetMapReduceTest.ListSetMapper()).combiner((CombinerFactory)new ListSetMapReduceTest.ListSetCombinerFactory()).reducer((ReducerFactory)new ListSetMapReduceTest.ListSetReducerFactory()).submit();
        Map result = (Map)ICompletableFuture2.get();
        Assert.assertEquals((long)1L, (long)result.size());
        for (Map.Entry entry : result.entrySet()) {
            Assert.assertEquals((Object)set.getName(), entry.getKey());
            Assert.assertEquals((long)expectedResult, (long)((Integer)entry.getValue()).intValue());
        }
    }
}

