/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.mapreduce.aggregation.PropertyExtractor;
import com.hazelcast.test.HazelcastTestSupport;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Random;
import org.junit.After;
import org.junit.Before;

public class AbstractAggregationTest
extends HazelcastTestSupport {
    private static final int VALUES_COUNT = 100;
    private static final Random RANDOM = new Random();
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    protected HazelcastInstance client;

    @Before
    public void startup() {
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance();
        AbstractAggregationTest.assertClusterSizeEventually((int)2, (HazelcastInstance)h1);
        AbstractAggregationTest.assertClusterSizeEventually((int)2, (HazelcastInstance)h2);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    protected static int random(int min, int max) {
        int delta = max - min;
        return min + RANDOM.nextInt(delta);
    }

    protected static <T> T[] buildPlainValues(ValueProvider<T> valueProvider, Class<T> type) {
        Object[] values = (Object[])Array.newInstance(type, 100);
        for (int i = 0; i < 100; ++i) {
            values[i] = valueProvider.provideRandom(RANDOM);
        }
        return values;
    }

    protected static <T> Value<T>[] buildValues(ValueProvider<T> valueProvider) {
        Value[] values = new Value[100];
        for (int i = 0; i < 100; ++i) {
            T value = valueProvider.provideRandom(RANDOM);
            values[i] = AbstractAggregationTest.value(value);
        }
        return values;
    }

    private static <T> Value<T> value(T value) {
        return new Value<T>(value);
    }

    public static class Value<T>
    implements Serializable {
        public T value;

        public Value() {
        }

        public Value(T value) {
            this.value = value;
        }
    }

    public static class ValuePropertyExtractor<T>
    implements PropertyExtractor<Value<T>, T>,
    Serializable {
        public T extract(Value<T> value) {
            return value.value;
        }
    }

    protected static interface ValueProvider<T> {
        public T provideRandom(Random var1);
    }
}

