/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.mapreduce.aggregation.AbstractAggregationTest;
import com.hazelcast.core.IMap;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Aggregations;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class BaseAggregationTest
extends AbstractAggregationTest {
    @Test
    public void testCountAggregation() throws Exception {
        String mapName = BaseAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        Integer[] values = BaseAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        }, Integer.class);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), (Object)values[i]);
        }
        Supplier supplier = Supplier.all();
        Aggregation aggregation = Aggregations.count();
        long count = (Long)map.aggregate(supplier, aggregation);
        Assert.assertEquals((long)values.length, (long)count);
    }

    @Test
    public void testDistinctValuesAggregation() throws Exception {
        final String[] probes = new String[]{"Dog", "Food", "Champion", "Hazelcast", "Security", "Integer", "Random", "System"};
        HashSet<String> expectation = new HashSet<String>(Arrays.asList(probes));
        String mapName = BaseAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        String[] values = BaseAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<String>(){

            @Override
            public String provideRandom(Random random) {
                int index = random.nextInt(probes.length);
                return probes[index];
            }
        }, String.class);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), (Object)values[i]);
        }
        Supplier supplier = Supplier.all();
        Aggregation aggregation = Aggregations.distinctValues();
        Set distinctValues = (Set)map.aggregate(supplier, aggregation);
        Assert.assertEquals(expectation, (Object)distinctValues);
    }
}

