/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.mapreduce.aggregation.AbstractAggregationTest;
import com.hazelcast.core.IMap;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Aggregations;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class MinAggregationTest
extends AbstractAggregationTest {
    @Test(timeout=60000L)
    public void testBigDecimalMin() throws Exception {
        BigDecimal[] values = MinAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigDecimal.class);
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            BigDecimal value = values[i];
            expectation = i == 0 ? value : expectation.min(value);
        }
        Aggregation aggregation = Aggregations.bigDecimalMin();
        BigDecimal result = (BigDecimal)this.testMin(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testBigIntegerMin() throws Exception {
        BigInteger[] values = MinAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigInteger.class);
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            BigInteger value = values[i];
            expectation = i == 0 ? value : expectation.min(value);
        }
        Aggregation aggregation = Aggregations.bigIntegerMin();
        BigInteger result = (BigInteger)this.testMin(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testDoubleMin() throws Exception {
        Double[] values = MinAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        }, Double.class);
        double expectation = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (!(value < expectation)) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.doubleMin();
        double result = (Double)this.testMin(values, aggregation);
        Assert.assertEquals((double)expectation, (double)result, (double)0.0);
    }

    @Test(timeout=60000L)
    public void testIntegerMin() throws Exception {
        Integer[] values = MinAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        }, Integer.class);
        int expectation = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            if (value >= expectation) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.integerMin();
        int result = (Integer)this.testMin(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testLongMin() throws Exception {
        Long[] values = MinAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        }, Long.class);
        long expectation = Long.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            if (value >= expectation) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.longMin();
        long result = (Long)this.testMin(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testBigDecimalMinWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigDecimal>[] values = MinAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            AbstractAggregationTest.Value<BigDecimal> value = values[i];
            expectation = i == 0 ? (BigDecimal)value.value : expectation.min((BigDecimal)value.value);
        }
        Aggregation aggregation = Aggregations.bigDecimalMin();
        BigDecimal result = (BigDecimal)this.testMinWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testBigIntegerMinWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigInteger>[] values = MinAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            AbstractAggregationTest.Value<BigInteger> value = values[i];
            expectation = i == 0 ? (BigInteger)value.value : expectation.min((BigInteger)value.value);
        }
        Aggregation aggregation = Aggregations.bigIntegerMin();
        BigInteger result = (BigInteger)this.testMinWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testDoubleMinWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Double>[] values = MinAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        });
        double expectation = Double.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            double value = (Double)values[i].value;
            if (!(value < expectation)) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.doubleMin();
        double result = (Double)this.testMinWithExtractor(values, aggregation);
        Assert.assertEquals((double)expectation, (double)result, (double)0.0);
    }

    @Test(timeout=60000L)
    public void testIntegerMinWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Integer>[] values = MinAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        });
        int expectation = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            int value = (Integer)values[i].value;
            if (value >= expectation) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.integerMin();
        int result = (Integer)this.testMinWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testLongMinWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Long>[] values = MinAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        });
        long expectation = Long.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            long value = (Long)values[i].value;
            if (value >= expectation) continue;
            expectation = value;
        }
        Aggregation aggregation = Aggregations.longMin();
        long result = (Long)this.testMinWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    private <T, R> R testMin(T[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = MinAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), values[i]);
        }
        Supplier supplier = Supplier.all();
        return (R)map.aggregate(supplier, aggregation);
    }

    private <T, R> R testMinWithExtractor(AbstractAggregationTest.Value<T>[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = MinAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), values[i]);
        }
        Supplier supplier = Supplier.all(new AbstractAggregationTest.ValuePropertyExtractor());
        return (R)map.aggregate(supplier, aggregation);
    }
}

