/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.mapreduce.aggregation.AbstractAggregationTest;
import com.hazelcast.core.MultiMap;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Aggregations;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class SumAggregationMultiMapTest
extends AbstractAggregationTest {
    @Test
    public void testBigDecimalSum() throws Exception {
        BigDecimal[] values = SumAggregationMultiMapTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigDecimal.class);
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add(values[i]);
        }
        Aggregation aggregation = Aggregations.bigDecimalSum();
        BigDecimal result = (BigDecimal)this.testSum(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test
    public void testBigIntegerSum() throws Exception {
        BigInteger[] values = SumAggregationMultiMapTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigInteger.class);
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add(values[i]);
        }
        Aggregation aggregation = Aggregations.bigIntegerSum();
        BigInteger result = (BigInteger)this.testSum(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test
    public void testDoubleSum() throws Exception {
        Double[] values = SumAggregationMultiMapTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        }, Double.class);
        double expectation = 0.0;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].doubleValue();
        }
        Aggregation aggregation = Aggregations.doubleSum();
        double result = (Double)this.testSum(values, aggregation);
        Assert.assertEquals((double)expectation, (double)result, (double)0.0);
    }

    @Test
    public void testIntegerSum() throws Exception {
        Integer[] values = SumAggregationMultiMapTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        }, Integer.class);
        int expectation = 0;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].intValue();
        }
        Aggregation aggregation = Aggregations.integerSum();
        int result = (Integer)this.testSum(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test
    public void testLongSum() throws Exception {
        Long[] values = SumAggregationMultiMapTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        }, Long.class);
        long expectation = 0L;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].longValue();
        }
        Aggregation aggregation = Aggregations.longSum();
        long result = (Long)this.testSum(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test
    public void testBigDecimalSumWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigDecimal>[] values = SumAggregationMultiMapTest.buildValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add((BigDecimal)values[i].value);
        }
        Aggregation aggregation = Aggregations.bigDecimalSum();
        BigDecimal result = (BigDecimal)this.testSumWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test
    public void testBigIntegerSumWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigInteger>[] values = SumAggregationMultiMapTest.buildValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add((BigInteger)values[i].value);
        }
        Aggregation aggregation = Aggregations.bigIntegerSum();
        BigInteger result = (BigInteger)this.testSumWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test
    public void testDoubleSumWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Double>[] values = SumAggregationMultiMapTest.buildValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        });
        double expectation = 0.0;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Double)values[i].value).doubleValue();
        }
        Aggregation aggregation = Aggregations.doubleSum();
        double result = (Double)this.testSumWithExtractor(values, aggregation);
        Assert.assertEquals((double)expectation, (double)result, (double)0.0);
    }

    @Test
    public void testIntegerSumWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Integer>[] values = SumAggregationMultiMapTest.buildValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        });
        int expectation = 0;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Integer)values[i].value).intValue();
        }
        Aggregation aggregation = Aggregations.integerSum();
        int result = (Integer)this.testSumWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test
    public void testLongSumWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Long>[] values = SumAggregationMultiMapTest.buildValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        });
        long expectation = 0L;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Long)values[i].value).longValue();
        }
        Aggregation aggregation = Aggregations.longSum();
        long result = (Long)this.testSumWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    private <T, R> R testSum(T[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = SumAggregationMultiMapTest.randomMapName();
        MultiMap map = this.client.getMultiMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i / 2), values[i]);
        }
        Supplier supplier = Supplier.all();
        return (R)map.aggregate(supplier, aggregation);
    }

    private <T, R> R testSumWithExtractor(AbstractAggregationTest.Value<T>[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = SumAggregationMultiMapTest.randomMapName();
        MultiMap map = this.client.getMultiMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i / 2), values[i]);
        }
        Supplier supplier = Supplier.all(new AbstractAggregationTest.ValuePropertyExtractor());
        return (R)map.aggregate(supplier, aggregation);
    }
}

