/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.multimap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMultiMapLockTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testIsLocked_whenNotLocked() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "KeyNotLocked";
        boolean result = mm.isLocked((Object)key);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testLock() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testLock_whenKeyNull() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        mm.lock(null);
    }

    @Test(expected=NullPointerException.class)
    public void testUnLock_whenNullKey() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        mm.unlock(null);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnlock_whenNotLocked() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        mm.unlock((Object)"NOT_LOCKED");
    }

    @Test
    public void testUnLock() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "key";
        mm.lock((Object)key);
        mm.unlock((Object)key);
        Assert.assertFalse((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testUnlock_whenRentrantlyLockedBySelf() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "key";
        mm.lock((Object)key);
        mm.lock((Object)key);
        mm.unlock((Object)key);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void testUnlock_whenLockedByOther() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "key";
        mm.lock((Object)key);
        UnLockThread t = new UnLockThread(mm, (Object)key);
        t.start();
        ClientMultiMapLockTest.assertJoinable((Thread[])new Thread[]{t});
        throw t.exception;
    }

    @Test
    public void testLock_whenAlreadyLockedBySelf() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        mm.lock((Object)key);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testTryLock() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "key";
        Assert.assertTrue((boolean)mm.tryLock((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testTryLock_whenNullKey() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        mm.tryLock(null);
    }

    @Test
    public void testTryLock_whenLockedBySelf() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        Assert.assertTrue((boolean)mm.tryLock((Object)key));
    }

    @Test
    public void testTryLock_whenLockedByOther() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "Key1";
        mm.lock((Object)key);
        final CountDownLatch tryLockFailed = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                if (!mm.tryLock(key)) {
                    tryLockFailed.countDown();
                }
            }
        }.start();
        ClientMultiMapLockTest.assertOpenEventually((CountDownLatch)tryLockFailed);
    }

    @Test
    public void testTryLockWaitingOnLockedKey_thenKeyUnlockedByOtherThread() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "keyZ";
        mm.lock((Object)key);
        final CountDownLatch tryLockReturnsTrue = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (mm.tryLock(key, 10L, TimeUnit.SECONDS)) {
                        tryLockReturnsTrue.countDown();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        mm.unlock((Object)key);
        ClientMultiMapLockTest.assertOpenEventually((CountDownLatch)tryLockReturnsTrue);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test(expected=NullPointerException.class)
    public void testForceUnlock_whenKeyNull() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        mm.forceUnlock(null);
    }

    @Test
    public void testForceUnlock_whenKeyLocked() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        mm.forceUnlock((Object)key);
        Assert.assertFalse((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testForceUnlock_whenKeyLockedTwice() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        mm.lock((Object)key);
        mm.forceUnlock((Object)key);
        Assert.assertFalse((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testForceUnlock_whenKeyLockedByOther() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "key";
        mm.lock((Object)key);
        final CountDownLatch forceUnlock = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                mm.forceUnlock(key);
                forceUnlock.countDown();
            }
        }.start();
        ClientMultiMapLockTest.assertOpenEventually((CountDownLatch)forceUnlock);
        Assert.assertFalse((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testForceUnlock_whenKeyLockedTwiceByOther() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "key";
        mm.lock((Object)key);
        mm.lock((Object)key);
        final CountDownLatch forceUnlock = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                mm.forceUnlock(key);
                forceUnlock.countDown();
            }
        }.start();
        ClientMultiMapLockTest.assertOpenEventually((CountDownLatch)forceUnlock);
        Assert.assertFalse((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testLockTTL() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key, 30L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLockTTL_whenZeroTimeout() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key, 0L, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLockTTL_whenNegativeTimeout() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key, -1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testLockTTL_whenLockedBySelf() throws Exception {
        MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        String key = "Key";
        mm.lock((Object)key);
        mm.lock((Object)key, 30L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)mm.isLocked((Object)key));
    }

    @Test
    public void testLockTTLExpired() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "Key";
        mm.lock((Object)key, 1L, TimeUnit.SECONDS);
        ClientMultiMapLockTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)mm.isLocked(key));
            }
        });
    }

    @Test
    public void testLockTTLExpired_whenLockedBySelf() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "Key";
        mm.lock((Object)key);
        mm.lock((Object)key, 1L, TimeUnit.SECONDS);
        ClientMultiMapLockTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)mm.isLocked(key));
            }
        });
    }

    @Test
    public void testLockTTLExpires_thenOtherThreadCanObtain() throws Exception {
        final MultiMap mm = this.client.getMultiMap(ClientMultiMapLockTest.randomString());
        final String key = "Key";
        mm.lock((Object)key, 2L, TimeUnit.SECONDS);
        final CountDownLatch tryLockSuccess = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    if (mm.tryLock(key, 10L, TimeUnit.SECONDS)) {
                        tryLockSuccess.countDown();
                    }
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }.start();
        ClientMultiMapLockTest.assertOpenEventually((CountDownLatch)tryLockSuccess);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockFree() throws InterruptedException {
        MultiMap multiMap = this.getMultiMapForLock();
        String key = ClientMultiMapLockTest.randomString();
        boolean isLocked = multiMap.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)isLocked);
    }

    @Test(timeout=60000L)
    public void testTryLockLeaseTime_whenLockAcquiredByOther() throws InterruptedException {
        final MultiMap multiMap = this.getMultiMapForLock();
        final String key = ClientMultiMapLockTest.randomString();
        Thread thread = new Thread(){

            @Override
            public void run() {
                multiMap.lock((Object)key);
            }
        };
        thread.start();
        thread.join();
        boolean isLocked = multiMap.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)isLocked);
    }

    @Test
    public void testTryLockLeaseTime_lockIsReleasedEventually() throws InterruptedException {
        final MultiMap multiMap = this.getMultiMapForLock();
        final String key = ClientMultiMapLockTest.randomString();
        multiMap.tryLock((Object)key, 1000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        ClientMultiMapLockTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)multiMap.isLocked((Object)key));
            }
        }, (long)30L);
    }

    private MultiMap getMultiMapForLock() {
        return this.client.getMultiMap(ClientMultiMapLockTest.randomString());
    }

    static class UnLockThread
    extends Thread {
        public Exception exception = null;
        public MultiMap mm = null;
        public Object key = null;

        public UnLockThread(MultiMap mm, Object key) {
            this.mm = mm;
            this.key = key;
        }

        @Override
        public void run() {
            try {
                this.mm.unlock(this.key);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

