/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.multimap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMultiMapTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testPut() {
        String key = "key1";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertTrue((boolean)mm.put((Object)key, (Object)1));
    }

    @Test(expected=NullPointerException.class)
    public void testPut_withNullValue() {
        String key = "key";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)key, null);
    }

    @Test(expected=NullPointerException.class)
    public void testPut_withNullKey() {
        String value = "value";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put(null, (Object)value);
    }

    @Test
    public void testPutMultiValuesToKey() {
        String key = "key1";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)key, (Object)1);
        Assert.assertTrue((boolean)mm.put((Object)key, (Object)2));
    }

    @Test
    public void testPut_WithExistingKeyValue() {
        String key = "key1";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertTrue((boolean)mm.put((Object)key, (Object)1));
        Assert.assertFalse((boolean)mm.put((Object)key, (Object)1));
    }

    @Test
    public void testValueCount() {
        String key = "key1";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)key, (Object)1);
        mm.put((Object)key, (Object)2);
        Assert.assertEquals((long)2L, (long)mm.valueCount((Object)key));
    }

    @Test
    public void testValueCount_whenKeyNotThere() {
        String key = "key1";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertEquals((long)0L, (long)mm.valueCount((Object)"NOT_THERE"));
    }

    @Test
    public void testSizeCount() {
        String key1 = "key1";
        String key2 = "key2";
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)key1, (Object)1);
        mm.put((Object)key1, (Object)2);
        mm.put((Object)key2, (Object)1);
        mm.put((Object)key2, (Object)2);
        mm.put((Object)key2, (Object)2);
        Assert.assertEquals((long)4L, (long)mm.size());
    }

    @Test
    public void testEmptySizeCount() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertEquals((long)0L, (long)mm.size());
    }

    @Test
    public void testGet_whenNotExist() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Collection coll = mm.get((Object)"NOT_THERE");
        Assert.assertTrue((boolean)coll.isEmpty());
    }

    @Test
    public void testGet() {
        String key = "key";
        int maxItemsPerKey = 33;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        TreeSet<Integer> expected = new TreeSet<Integer>();
        for (int i = 0; i < 33; ++i) {
            mm.put((Object)key, (Object)i);
            expected.add(i);
        }
        TreeSet resultSet = new TreeSet(mm.get((Object)key));
        Assert.assertEquals(expected, resultSet);
    }

    @Test
    public void testRemove_whenKeyNotExist() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Collection coll = mm.remove((Object)"NOT_THERE");
        Assert.assertTrue((boolean)coll.isEmpty());
    }

    @Test
    public void testRemoveKey() {
        String key = "key";
        int maxItemsPerKey = 44;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        TreeSet<Integer> expeted = new TreeSet<Integer>();
        for (int i = 0; i < 44; ++i) {
            mm.put((Object)key, (Object)i);
            expeted.add(i);
        }
        TreeSet resultSet = new TreeSet(mm.remove((Object)key));
        Assert.assertEquals(expeted, resultSet);
        Assert.assertEquals((long)0L, (long)mm.size());
    }

    @Test
    public void testRemoveValue_whenValueNotExists() {
        String key = "key";
        int maxItemsPerKey = 4;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        for (int i = 0; i < 4; ++i) {
            mm.put((Object)key, (Object)i);
        }
        boolean result = mm.remove((Object)key, (Object)"NOT_THERE");
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testRemoveKeyValue() {
        int i;
        String key = "key";
        int maxItemsPerKey = 4;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        for (i = 0; i < 4; ++i) {
            mm.put((Object)key, (Object)i);
        }
        for (i = 0; i < 4; ++i) {
            boolean result = mm.remove((Object)key, (Object)i);
            Assert.assertTrue((boolean)result);
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testLocalKeySet() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.localKeySet();
    }

    @Test
    public void testEmptyKeySet() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)mm.keySet());
    }

    @Test
    public void testKeySet() {
        int maxKeys = 23;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        TreeSet<Integer> expected = new TreeSet<Integer>();
        for (int key = 0; key < 23; ++key) {
            mm.put((Object)key, (Object)1);
            expected.add(key);
        }
        Assert.assertEquals(expected, (Object)mm.keySet());
    }

    @Test
    public void testValues_whenEmptyCollection() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)mm.values());
    }

    @Test
    public void testKeyValues() {
        int maxKeys = 31;
        int maxValues = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        TreeSet<Integer> expected = new TreeSet<Integer>();
        for (int key = 0; key < 31; ++key) {
            for (int val = 0; val < 3; ++val) {
                mm.put((Object)key, (Object)val);
                expected.add(val);
            }
        }
        TreeSet resultSet = new TreeSet(mm.values());
        Assert.assertEquals(expected, resultSet);
    }

    @Test
    public void testEntrySet_whenEmpty() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)mm.entrySet());
    }

    @Test
    public void testEntrySet() {
        int maxKeys = 14;
        int maxValues = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        for (int key = 0; key < 14; ++key) {
            for (int val = 0; val < 3; ++val) {
                mm.put((Object)key, (Object)val);
            }
        }
        Assert.assertEquals((long)42L, (long)mm.entrySet().size());
    }

    @Test
    public void testContainsKey_whenKeyExists() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)"key1", (Object)"value1");
        Assert.assertTrue((boolean)mm.containsKey((Object)"key1"));
    }

    @Test
    public void testContainsKey_whenKeyNotExists() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)mm.containsKey((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testContainsKey_whenKeyNull() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.containsKey(null);
    }

    @Test
    public void testContainsValue_whenExists() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)"key1", (Object)"value1");
        Assert.assertTrue((boolean)mm.containsValue((Object)"value1"));
        Assert.assertFalse((boolean)mm.containsValue((Object)"NOT_THERE"));
    }

    @Test
    public void testContainsValue_whenNotExists() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)mm.containsValue((Object)"NOT_THERE"));
    }

    @Test(expected=NullPointerException.class)
    public void testContainsValue_whenSearchValueNull() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.containsValue(null);
    }

    @Test
    public void testContainsEntry() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.put((Object)"key1", (Object)"value1");
        Assert.assertTrue((boolean)mm.containsEntry((Object)"key1", (Object)"value1"));
        Assert.assertFalse((boolean)mm.containsEntry((Object)"key1", (Object)"NOT_THERE"));
        Assert.assertFalse((boolean)mm.containsEntry((Object)"NOT_THERE", (Object)"NOT_THERE"));
        Assert.assertFalse((boolean)mm.containsEntry((Object)"NOT_THERE", (Object)"value1"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLocalMultiMapStats() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.getLocalMultiMapStats();
    }

    @Test
    public void testClear() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        int maxKeys = 9;
        int maxValues = 3;
        for (int key = 0; key < 9; ++key) {
            for (int val = 0; val < 3; ++val) {
                mm.put((Object)key, (Object)val);
            }
        }
        mm.clear();
        Assert.assertEquals((long)0L, (long)mm.size());
    }
}

