/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ProxyEqualityTest {
    private final TestHazelcastFactory hazelcastFactoryGroupA = new TestHazelcastFactory();
    private final TestHazelcastFactory hazelcastFactoryGroupB = new TestHazelcastFactory();
    private final String atomicName = "foo";
    private HazelcastInstance client1GroupA;
    private HazelcastInstance client2GroupA;
    private HazelcastInstance client1GroupB;

    @After
    public void tearDown() {
        this.hazelcastFactoryGroupA.terminateAll();
        this.hazelcastFactoryGroupB.terminateAll();
    }

    @Before
    public void setup() throws Exception {
        Config config = new Config();
        String groupAName = "GroupA";
        config.getGroupConfig().setName(groupAName);
        this.hazelcastFactoryGroupA.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setGroupConfig(new GroupConfig(config.getGroupConfig().getName()));
        this.client1GroupA = this.hazelcastFactoryGroupA.newHazelcastClient(clientConfig);
        this.client2GroupA = this.hazelcastFactoryGroupA.newHazelcastClient(clientConfig);
        config = new Config();
        String groupBName = "GroupB";
        config.getGroupConfig().setName(groupBName);
        this.hazelcastFactoryGroupB.newHazelcastInstance(config);
        clientConfig = new ClientConfig();
        clientConfig.setGroupConfig(new GroupConfig(config.getGroupConfig().getName()));
        this.client1GroupB = this.hazelcastFactoryGroupB.newHazelcastClient(clientConfig);
    }

    @Test
    public void testTwoClientProxiesFromTheSameInstanceAreEquals() {
        ClientProxy ref1 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        ClientProxy ref2 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        Assert.assertEquals((Object)ref1, (Object)ref2);
    }

    @Test
    public void testProxiesAreCached() {
        ClientProxy ref1 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        ClientProxy ref2 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        Assert.assertSame((Object)ref1, (Object)ref2);
    }

    @Test
    public void testTwoClientProxiesFromDifferentInstancesAreNotEquals() {
        ClientProxy ref1 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        ClientProxy ref2 = (ClientProxy)this.client1GroupB.getAtomicLong("foo");
        Assert.assertNotEquals((Object)ref1, (Object)ref2);
    }

    @Test
    public void testTwoClientProxiesFromTwoDifferentClientsConnectedToTheSameInstanceAreNotEquals() {
        ClientProxy ref1 = (ClientProxy)this.client1GroupA.getAtomicLong("foo");
        ClientProxy ref2 = (ClientProxy)this.client2GroupA.getAtomicLong("foo");
        Assert.assertNotEquals((Object)ref1, (Object)ref2);
    }
}

