/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.queue;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Ignore;

@Ignore(value="Not a JUnit test")
public class ClientQueuePerformanceTest {
    static final AtomicLong totalOffer = new AtomicLong();
    static final AtomicLong totalPoll = new AtomicLong();
    static final AtomicLong totalPeek = new AtomicLong();
    static final int THREAD_COUNT = 40;
    static final byte[] VALUE = new byte[1000];
    static HazelcastInstance server;
    static HazelcastInstance second;
    static HazelcastInstance client;
    static IQueue q;

    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
        server = Hazelcast.newHazelcastInstance();
        second = Hazelcast.newHazelcastInstance();
        client = HazelcastClient.newHazelcastClient(null);
        q = client.getQueue("test");
        ClientQueuePerformanceTest.test2();
    }

    public static void test1() throws Exception {
        final Random rnd = new Random();
        for (int i = 0; i < 40; ++i) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        int random;
                        if ((random = rnd.nextInt(100)) > 54) {
                            q.poll();
                            totalPoll.incrementAndGet();
                            continue;
                        }
                        if (random > 4) {
                            q.offer((Object)VALUE);
                            totalOffer.incrementAndGet();
                            continue;
                        }
                        q.peek();
                        totalPeek.incrementAndGet();
                    }
                }
            }.start();
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            int size;
                            if ((size = q.size()) > 50000) {
                                System.err.println("cleaning a little");
                                for (int i = 0; i < 20000; ++i) {
                                    q.poll();
                                    totalPoll.incrementAndGet();
                                }
                                Thread.sleep(2000L);
                                continue;
                            }
                            Thread.sleep(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        while (true) {
            long sleepTime = 10L;
            Thread.sleep(sleepTime * 1000L);
            long totalOfferVal = totalOffer.getAndSet(0L);
            long totalPollVal = totalPoll.getAndSet(0L);
            long totalPeekVal = totalPeek.getAndSet(0L);
            System.err.println("_______________________________________________________________________________________");
            System.err.println(" offer: " + totalOfferVal + ",\t poll: " + totalPollVal + ",\t peek: " + totalPeekVal);
            System.err.println(" size: " + q.size() + " \t speed: " + (totalOfferVal + totalPollVal + totalPeekVal) / sleepTime);
            System.err.println("---------------------------------------------------------------------------------------");
            System.err.println("");
        }
    }

    public static void test2() throws Exception {
        final CountDownLatch latch = new CountDownLatch(100);
        final CountDownLatch latch1 = new CountDownLatch(1000);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    q.offer((Object)("item" + i));
                    latch.countDown();
                    latch1.countDown();
                }
            }
        }.start();
        latch.await();
        server.shutdown();
        latch1.await();
        System.err.println("size: " + q.size());
    }
}

