/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum;

import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.quorum.PartitionedCluster;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapReadQuorumTest
extends HazelcastTestSupport {
    private static final String MAP_NAME_PREFIX = "quorum";
    private static final String QUORUM_ID = "threeNodeQuorumRule";
    static PartitionedCluster cluster;
    static IMap<Object, Object> map1;
    static IMap<Object, Object> map2;
    static IMap<Object, Object> map3;
    static IMap<Object, Object> map4;
    static IMap<Object, Object> map5;
    static HazelcastInstance c1;
    static HazelcastInstance c2;
    static HazelcastInstance c3;
    static HazelcastInstance c4;
    static HazelcastInstance c5;
    private static TestHazelcastFactory factory;

    @BeforeClass
    public static void initialize() throws Exception {
        QuorumConfig quorumConfig = new QuorumConfig();
        quorumConfig.setName(QUORUM_ID);
        quorumConfig.setEnabled(true);
        quorumConfig.setSize(3);
        quorumConfig.setType(QuorumType.READ);
        MapConfig mapConfig = new MapConfig("quorum*");
        mapConfig.setQuorumName(QUORUM_ID);
        factory = new TestHazelcastFactory();
        cluster = new PartitionedCluster((TestHazelcastInstanceFactory)factory).partitionFiveMembersThreeAndTwo(mapConfig, quorumConfig);
        ClientMapReadQuorumTest.initializeClients();
        ClientMapReadQuorumTest.verifyClients();
    }

    private static void initializeClients() {
        c1 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadQuorumTest.cluster.h1));
        c2 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadQuorumTest.cluster.h2));
        c3 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadQuorumTest.cluster.h3));
        c4 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadQuorumTest.cluster.h4));
        c5 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadQuorumTest.cluster.h5));
    }

    private static void verifyClients() {
        ClientMapReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c1);
        ClientMapReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c2);
        ClientMapReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c3);
        ClientMapReadQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c4);
        ClientMapReadQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c5);
    }

    @Before
    public void setUp() {
        String mapName = ClientMapReadQuorumTest.randomMapName((String)MAP_NAME_PREFIX);
        map1 = c1.getMap(mapName);
        map2 = c2.getMap(mapName);
        map3 = c3.getMap(mapName);
        map4 = c4.getMap(mapName);
        map5 = c5.getMap(mapName);
    }

    @AfterClass
    public static void killAllHazelcastInstances() {
        factory.terminateAll();
    }

    @Test
    public void testGetOperationSuccessfulWhenQuorumSizeMet() {
        map1.get((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testGetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.get((Object)"foo");
    }

    @Test
    public void testGetAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = map1.getAsync((Object)"foo");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = map4.getAsync((Object)"foo");
        foo.get();
    }

    @Test
    public void testGetAllOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map1.getAll(keys);
    }

    @Test(expected=QuorumException.class)
    public void testGetAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map4.getAll(keys);
    }

    @Test
    public void testGetEntryViewOperationSuccessfulWhenQuorumSizeMet() {
        map1.getEntryView((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testGetEntryViewOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.getEntryView((Object)"foo");
    }

    @Test
    public void testContainsKeyOperationSuccessfulWhenQuorumSizeMet() {
        map1.containsKey((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testContainsKeyOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.containsKey((Object)"foo");
    }

    @Test
    public void testContainsValueOperationSuccessfulWhenQuorumSizeMet() {
        map1.containsValue((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testContainsValueOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.containsValue((Object)"foo");
    }

    @Test
    public void testKeySetOperationSuccessfulWhenQuorumSizeMet() {
        map1.keySet();
    }

    @Test(expected=QuorumException.class)
    public void testKeySetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.keySet();
    }

    @Test
    public void testValuesOperationSuccessfulWhenQuorumSizeMet() {
        map1.values();
    }

    @Test(expected=QuorumException.class)
    public void testValuesOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.values();
    }

    @Test
    public void testEntrySetOperationSuccessfulWhenQuorumSizeMet() {
        map1.entrySet();
    }

    @Test(expected=QuorumException.class)
    public void testEntrySetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.entrySet();
    }
}

