/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum;

import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.InterceptorTest;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.TestLoggingEntryProcessor;
import com.hazelcast.quorum.PartitionedCluster;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapReadWriteQuorumTest
extends HazelcastTestSupport {
    private static final String MAP_NAME_PREFIX = "quorum";
    private static final String QUORUM_ID = "threeNodeQuorumRule";
    static PartitionedCluster cluster;
    static IMap<Object, Object> map1;
    static IMap<Object, Object> map2;
    static IMap<Object, Object> map3;
    static IMap<Object, Object> map4;
    static IMap<Object, Object> map5;
    static HazelcastInstance c1;
    static HazelcastInstance c2;
    static HazelcastInstance c3;
    static HazelcastInstance c4;
    static HazelcastInstance c5;
    private static TestHazelcastFactory factory;

    @BeforeClass
    public static void initialize() throws Exception {
        QuorumConfig quorumConfig = new QuorumConfig();
        quorumConfig.setName(QUORUM_ID);
        quorumConfig.setEnabled(true);
        quorumConfig.setSize(3);
        quorumConfig.setType(QuorumType.READ_WRITE);
        MapConfig mapConfig = new MapConfig("quorum*");
        mapConfig.setQuorumName(QUORUM_ID);
        factory = new TestHazelcastFactory();
        cluster = new PartitionedCluster((TestHazelcastInstanceFactory)factory).partitionFiveMembersThreeAndTwo(mapConfig, quorumConfig);
        ClientMapReadWriteQuorumTest.initializeClients();
        ClientMapReadWriteQuorumTest.verifyClients();
    }

    private static void initializeClients() {
        c1 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadWriteQuorumTest.cluster.h1));
        c2 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadWriteQuorumTest.cluster.h2));
        c3 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadWriteQuorumTest.cluster.h3));
        c4 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadWriteQuorumTest.cluster.h4));
        c5 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientMapReadWriteQuorumTest.cluster.h5));
    }

    private static void verifyClients() {
        ClientMapReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c1);
        ClientMapReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c2);
        ClientMapReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c3);
        ClientMapReadWriteQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c4);
        ClientMapReadWriteQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c5);
    }

    @Before
    public void setUp() {
        String mapName = ClientMapReadWriteQuorumTest.randomMapName((String)MAP_NAME_PREFIX);
        map1 = c1.getMap(mapName);
        map2 = c2.getMap(mapName);
        map3 = c3.getMap(mapName);
        map4 = c4.getMap(mapName);
        map5 = c5.getMap(mapName);
    }

    @AfterClass
    public static void killAllHazelcastInstances() {
        factory.terminateAll();
    }

    @Test
    public void testPutOperationSuccessfulWhenQuorumSizeMet() {
        map1.put((Object)"foo", (Object)"bar");
    }

    @Test(expected=QuorumException.class)
    public void testPutOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.put((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTryPutOperationSuccessfulWhenQuorumSizeMet() {
        map1.tryPut((Object)"foo", (Object)"bar", 5L, TimeUnit.SECONDS);
    }

    @Test(expected=QuorumException.class)
    public void testTryPutOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.tryPut((Object)"foo", (Object)"bar", 5L, TimeUnit.SECONDS);
    }

    @Test
    public void testPutTransientOperationSuccessfulWhenQuorumSizeMet() {
        map1.putTransient((Object)"foo", (Object)"bar", 5L, TimeUnit.SECONDS);
    }

    @Test(expected=QuorumException.class)
    public void testPutTransientOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.putTransient((Object)"foo", (Object)"bar", 5L, TimeUnit.SECONDS);
    }

    @Test
    public void testPutIfAbsentOperationSuccessfulWhenQuorumSizeMet() {
        map1.putIfAbsent((Object)"foo", (Object)"bar");
    }

    @Test(expected=QuorumException.class)
    public void testPutIfAbsentOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.putIfAbsent((Object)"foo", (Object)"bar");
    }

    @Test
    public void testPutAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = map1.putAsync((Object)"foo", (Object)"bar");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testPutAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = map4.putAsync((Object)"foo", (Object)"bar");
        foo.get();
    }

    @Test
    public void testPutAllOperationSuccessfulWhenQuorumSizeMet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        map1.putAll(map);
    }

    @Test(expected=QuorumException.class)
    public void testPutAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        map4.putAll(map);
    }

    @Test
    public void testGetOperationSuccessfulWhenQuorumSizeMet() {
        map1.get((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testGetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.get((Object)"foo");
    }

    @Test
    public void testGetAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = map1.getAsync((Object)"foo");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = map4.getAsync((Object)"foo");
        foo.get();
    }

    @Test
    public void testGetAllOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map1.getAll(keys);
    }

    @Test(expected=QuorumException.class)
    public void testGetAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map4.getAll(keys);
    }

    @Test
    public void testGetEntryViewOperationSuccessfulWhenQuorumSizeMet() {
        map1.getEntryView((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testGetEntryViewOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.getEntryView((Object)"foo");
    }

    @Test
    public void testRemoveOperationSuccessfulWhenQuorumSizeMet() {
        map1.remove((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testRemoveOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.remove((Object)"foo");
    }

    @Test
    public void testRemoveIfHasValueOperationSuccessfulWhenQuorumSizeMet() {
        map1.remove((Object)"foo", (Object)"bar");
    }

    @Test(expected=QuorumException.class)
    public void testRemoveIfHasValueOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.remove((Object)"foo", (Object)"bar");
    }

    @Test
    public void testRemoveAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = map1.removeAsync((Object)"foo");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testRemoveAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = map4.removeAsync((Object)"foo");
        foo.get();
    }

    @Test
    public void testDeleteOperationSuccessfulWhenQuorumSizeMet() {
        map1.delete((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testDeleteOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.delete((Object)"foo");
    }

    @Test
    public void testClearOperationSuccessfulWhenQuorumSizeMet() {
        map1.clear();
    }

    @Test(expected=QuorumException.class)
    public void testClearOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.clear();
    }

    @Test
    public void testSetOperationSuccessfulWhenQuorumSizeMet() {
        map1.set((Object)"foo", (Object)"bar");
    }

    @Test(expected=QuorumException.class)
    public void testSetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.set((Object)"foo", (Object)"bar");
    }

    @Test
    public void testReplaceOperationSuccessfulWhenQuorumSizeMet() {
        map1.replace((Object)"foo", (Object)"bar");
    }

    @Test(expected=QuorumException.class)
    public void testReplaceOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.replace((Object)"foo", (Object)"bar");
    }

    @Test
    public void testReplaceIfOperationSuccessfulWhenQuorumSizeMet() {
        map1.replace((Object)"foo", (Object)"bar", (Object)"baz");
    }

    @Test(expected=QuorumException.class)
    public void testReplaceIfOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.replace((Object)"foo", (Object)"bar", (Object)"baz");
    }

    @Test
    public void testTryRemoveOperationSuccessfulWhenQuorumSizeMet() {
        map1.tryRemove((Object)"foo", 5L, TimeUnit.SECONDS);
    }

    @Test(expected=QuorumException.class)
    public void testTryRemoveOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.tryRemove((Object)"foo", 5L, TimeUnit.SECONDS);
    }

    @Test
    public void testFlushOperationSuccessfulWhenQuorumSizeMet() {
        map1.flush();
    }

    @Test(expected=QuorumException.class)
    public void testFlushOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.flush();
    }

    @Test
    public void testEvictAllOperationSuccessfulWhenQuorumSizeMet() {
        map1.evictAll();
    }

    @Test(expected=QuorumException.class)
    public void testEvictAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.evictAll();
    }

    @Test
    public void testEvictOperationSuccessfulWhenQuorumSizeMet() {
        map1.evict((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testEvictOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.evict((Object)"foo");
    }

    @Test
    public void testContainsKeyOperationSuccessfulWhenQuorumSizeMet() {
        map1.containsKey((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testContainsKeyOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.containsKey((Object)"foo");
    }

    @Test
    public void testContainsValueOperationSuccessfulWhenQuorumSizeMet() {
        map1.containsValue((Object)"foo");
    }

    @Test(expected=QuorumException.class)
    public void testContainsValueOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.containsValue((Object)"foo");
    }

    @Test
    public void testKeySetOperationSuccessfulWhenQuorumSizeMet() {
        map1.keySet();
    }

    @Test(expected=QuorumException.class)
    public void testKeySetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.keySet();
    }

    @Test
    public void testValuesOperationSuccessfulWhenQuorumSizeMet() {
        map1.values();
    }

    @Test(expected=QuorumException.class)
    public void testValuesOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.values();
    }

    @Test
    public void testEntrySetOperationSuccessfulWhenQuorumSizeMet() {
        map1.entrySet();
    }

    @Test(expected=QuorumException.class)
    public void testEntrySetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.entrySet();
    }

    @Test
    public void testAddIndexOperationSuccessfulWhenQuorumSizeMet() {
        map1.addIndex("foo", false);
    }

    @Test(expected=QuorumException.class)
    public void testAddIndexOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.addIndex("foo", false);
    }

    @Test
    public void testAddInterceptorOperationSuccessfulWhenQuorumSizeMet() {
        map1.addInterceptor((MapInterceptor)new InterceptorTest.SimpleInterceptor());
    }

    @Test(expected=QuorumException.class)
    public void testAddInterceptorOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.addInterceptor((MapInterceptor)new InterceptorTest.SimpleInterceptor());
    }

    @Test
    public void testRemoveInterceptorOperationSuccessfulWhenQuorumSizeMet() {
        map1.removeInterceptor("foo");
    }

    @Test(expected=QuorumException.class)
    public void testRemoveInterceptorOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.removeInterceptor("foo");
    }

    @Test
    public void testExecuteOnKeyOperationSuccessfulWhenQuorumSizeMet() {
        map1.executeOnKey((Object)"foo", (EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test(expected=QuorumException.class)
    public void testExecuteOnKeyOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.executeOnKey((Object)"foo", (EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test
    public void testExecuteOnKeysOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map1.executeOnKey(keys, (EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test(expected=QuorumException.class)
    public void testExecuteOnKeysOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("foo");
        map4.executeOnKey(keys, (EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test
    public void testExecuteOnEntriesOperationSuccessfulWhenQuorumSizeMet() {
        map1.executeOnEntries((EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test(expected=QuorumException.class)
    public void testExecuteOnEntriesOperationThrowsExceptionWhenQuorumSizeNotMet() {
        map4.executeOnEntries((EntryProcessor)new TestLoggingEntryProcessor());
    }

    @Test
    public void testSubmitToKeyOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = map1.submitToKey((Object)"foo", (EntryProcessor)new TestLoggingEntryProcessor());
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testSubmitToKeyOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = map4.submitToKey((Object)"foo", (EntryProcessor)new TestLoggingEntryProcessor());
        foo.get();
    }
}

