/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum;

import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.quorum.PartitionedCluster;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTransactionalMapQuorumTest
extends HazelcastTestSupport {
    private static final String MAP_NAME_PREFIX = "quorum";
    private static final String QUORUM_ID = "threeNodeQuorumRule";
    static PartitionedCluster cluster;
    static HazelcastInstance c1;
    static HazelcastInstance c2;
    static HazelcastInstance c3;
    static HazelcastInstance c4;
    static HazelcastInstance c5;
    private static TestHazelcastFactory factory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public TransactionOptions options;

    @Parameterized.Parameters(name="Options: {0}")
    public static Collection<Object[]> parameters() {
        TransactionOptions localOption = TransactionOptions.getDefault();
        localOption.setTransactionType(TransactionOptions.TransactionType.ONE_PHASE);
        TransactionOptions twoPhaseOption = TransactionOptions.getDefault();
        twoPhaseOption.setTransactionType(TransactionOptions.TransactionType.TWO_PHASE);
        return Arrays.asList({twoPhaseOption}, {localOption});
    }

    @BeforeClass
    public static void initialize() throws Exception {
        QuorumConfig quorumConfig = new QuorumConfig();
        quorumConfig.setEnabled(true);
        quorumConfig.setSize(3);
        quorumConfig.setName(QUORUM_ID);
        MapConfig mapConfig = new MapConfig("quorum*");
        mapConfig.setQuorumName(QUORUM_ID);
        factory = new TestHazelcastFactory();
        cluster = new PartitionedCluster((TestHazelcastInstanceFactory)factory).partitionFiveMembersThreeAndTwo(mapConfig, quorumConfig);
        ClientTransactionalMapQuorumTest.initializeClients();
        ClientTransactionalMapQuorumTest.verifyClients();
    }

    private static void initializeClients() {
        c1 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientTransactionalMapQuorumTest.cluster.h1));
        c2 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientTransactionalMapQuorumTest.cluster.h2));
        c3 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientTransactionalMapQuorumTest.cluster.h3));
        c4 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientTransactionalMapQuorumTest.cluster.h4));
        c5 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientTransactionalMapQuorumTest.cluster.h5));
    }

    private static void verifyClients() {
        ClientTransactionalMapQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c1);
        ClientTransactionalMapQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c2);
        ClientTransactionalMapQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c3);
        ClientTransactionalMapQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c4);
        ClientTransactionalMapQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c5);
    }

    @AfterClass
    public static void killAllHazelcastInstances() {
        factory.terminateAll();
    }

    @Test
    public void testTxPutThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.put((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTxPutSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.put((Object)"foo", (Object)"bar");
        transaction.commitTransaction();
    }

    @Test
    public void testTxGetThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.get((Object)"foo");
    }

    @Test
    public void testTxGetSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.get((Object)"foo");
        transaction.commitTransaction();
    }

    @Test
    public void testTxGetForUpdateThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.getForUpdate((Object)"foo");
    }

    @Test
    public void testTxGetForUpdateSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.getForUpdate((Object)"foo");
        transaction.commitTransaction();
    }

    @Test
    public void testTxRemoveThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.remove((Object)"foo");
    }

    @Test
    public void testTxRemoveSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.remove((Object)"foo");
        transaction.commitTransaction();
    }

    @Test
    public void testTxRemoveValueThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.remove((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTxRemoveValueSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.remove((Object)"foo", (Object)"bar");
        transaction.commitTransaction();
    }

    @Test
    public void testTxDeleteThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.delete((Object)"foo");
    }

    @Test
    public void testTxDeleteSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.delete((Object)"foo");
        transaction.commitTransaction();
    }

    @Test
    public void testTxSetThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.set((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTxSetSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.set((Object)"foo", (Object)"bar");
        transaction.commitTransaction();
    }

    @Test
    public void testTxPutWithTTLThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.put((Object)"foo", (Object)"bar", 10L, TimeUnit.SECONDS);
    }

    @Test
    public void testTxPutWithTTLSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.put((Object)"foo", (Object)"bar", 10L, TimeUnit.SECONDS);
        transaction.commitTransaction();
    }

    @Test
    public void testTxPutIfAbsentThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.putIfAbsent((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTxPutIfAbsentSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.putIfAbsent((Object)"foo", (Object)"bar");
        transaction.commitTransaction();
    }

    @Test
    public void testTxReplaceThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.replace((Object)"foo", (Object)"bar");
    }

    @Test
    public void testTxReplaceSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.replace((Object)"foo", (Object)"bar");
        transaction.commitTransaction();
    }

    @Test
    public void testTxReplaceExpectedValueThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.replace((Object)"foo", (Object)"bar", (Object)"baz");
    }

    @Test
    public void testTxReplaceExpectedValueSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.replace((Object)"foo", (Object)"bar", (Object)"baz");
        transaction.commitTransaction();
    }

    @Test
    public void testTxSizeThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.size();
    }

    @Test
    public void testTxSizeSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.size();
        transaction.commitTransaction();
    }

    @Test
    public void testTxContainsKeyThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.containsKey((Object)"foo");
    }

    @Test
    public void testTxContainsKeySucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.containsKey((Object)"foo");
        transaction.commitTransaction();
    }

    @Test
    public void testTxIsEmptyThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.isEmpty();
    }

    @Test
    public void testTxIsEmptySucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.isEmpty();
        transaction.commitTransaction();
    }

    @Test
    public void testTxKeySetThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.keySet();
    }

    @Test
    public void testTxKeySetSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.keySet();
        transaction.commitTransaction();
    }

    @Test
    public void testTxKeySetWithPredicateThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.keySet((Predicate)TruePredicate.INSTANCE);
    }

    @Test
    public void testTxKeySetWithPredicateSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.keySet((Predicate)TruePredicate.INSTANCE);
        transaction.commitTransaction();
    }

    @Test
    public void testTxValuesThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.values();
    }

    @Test
    public void testTxValuesSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.values();
        transaction.commitTransaction();
    }

    @Test
    public void testTxValuesWithPredicateThrowsExceptionWhenQuorumSizeNotMet() {
        TransactionContext transaction = this.getTransactionFromMinority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        this.expectedException.expect(QuorumException.class);
        map.values((Predicate)TruePredicate.INSTANCE);
    }

    @Test
    public void testTxValuesWithPredicateSucceedsWhenQuorumSizeMet() {
        TransactionContext transaction = this.getTransactionFromMajority();
        TransactionalMap<Object, Object> map = ClientTransactionalMapQuorumTest.getMap(transaction);
        map.values((Predicate)TruePredicate.INSTANCE);
        transaction.commitTransaction();
    }

    private TransactionContext getTransactionFromMajority() {
        TransactionContext transactionContext = c1.newTransactionContext(this.options);
        transactionContext.beginTransaction();
        return transactionContext;
    }

    private TransactionContext getTransactionFromMinority() {
        TransactionContext transactionContext = c4.newTransactionContext(this.options);
        transactionContext.beginTransaction();
        return transactionContext;
    }

    private static TransactionalMap<Object, Object> getMap(TransactionContext transaction) {
        return transaction.getMap(ClientTransactionalMapQuorumTest.randomMapName((String)MAP_NAME_PREFIX));
    }
}

