/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum.cache;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.quorum.PartitionedCluster;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheReadQuorumTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME_PREFIX = "cacheQuorum";
    private static final String QUORUM_ID = "threeNodeQuorumRule";
    static PartitionedCluster cluster;
    private static HazelcastClientCachingProvider cachingProvider1;
    private static HazelcastClientCachingProvider cachingProvider2;
    private static HazelcastClientCachingProvider cachingProvider3;
    private static HazelcastClientCachingProvider cachingProvider4;
    private static HazelcastClientCachingProvider cachingProvider5;
    private static HazelcastInstance c1;
    private static HazelcastInstance c2;
    private static HazelcastInstance c3;
    private static HazelcastInstance c4;
    private static HazelcastInstance c5;
    private static ICache<Integer, String> cache1;
    private static ICache<Integer, String> cache2;
    private static ICache<Integer, String> cache3;
    private static ICache<Integer, String> cache4;
    private static ICache<Integer, String> cache5;
    private static TestHazelcastFactory factory;

    @BeforeClass
    public static void initialize() throws Exception {
        QuorumConfig quorumConfig = new QuorumConfig();
        quorumConfig.setName(QUORUM_ID);
        quorumConfig.setType(QuorumType.READ);
        quorumConfig.setEnabled(true);
        quorumConfig.setSize(3);
        CacheSimpleConfig cacheConfig = new CacheSimpleConfig();
        cacheConfig.setName("cacheQuorum*");
        cacheConfig.setQuorumName(QUORUM_ID);
        factory = new TestHazelcastFactory();
        cluster = new PartitionedCluster((TestHazelcastInstanceFactory)factory).createFiveMemberCluster(cacheConfig, quorumConfig);
        ClientCacheReadQuorumTest.initializeClients();
        ClientCacheReadQuorumTest.initializeCaches();
        cluster.splitFiveMembersThreeAndTwo();
        ClientCacheReadQuorumTest.verifyClients();
    }

    private static void initializeClients() {
        c1 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadQuorumTest.cluster.h1));
        c2 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadQuorumTest.cluster.h2));
        c3 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadQuorumTest.cluster.h3));
        c4 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadQuorumTest.cluster.h4));
        c5 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadQuorumTest.cluster.h5));
    }

    private static void initializeCaches() {
        cachingProvider1 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c1);
        cachingProvider2 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c2);
        cachingProvider3 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c3);
        cachingProvider4 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c4);
        cachingProvider5 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c5);
        String cacheName = CACHE_NAME_PREFIX + ClientCacheReadQuorumTest.randomString();
        cache1 = (ICache)cachingProvider1.getCacheManager().getCache(cacheName);
        cache2 = (ICache)cachingProvider2.getCacheManager().getCache(cacheName);
        cache3 = (ICache)cachingProvider3.getCacheManager().getCache(cacheName);
        cache4 = (ICache)cachingProvider4.getCacheManager().getCache(cacheName);
        cache5 = (ICache)cachingProvider5.getCacheManager().getCache(cacheName);
    }

    private static void verifyClients() {
        ClientCacheReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c1);
        ClientCacheReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c2);
        ClientCacheReadQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c3);
        ClientCacheReadQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c4);
        ClientCacheReadQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c5);
    }

    @AfterClass
    public static void killAllHazelcastInstances() {
        factory.terminateAll();
    }

    @Test
    public void testGetOperationSuccessfulWhenQuorumSizeMet() {
        cache1.get((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testGetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.get((Object)1);
    }

    @Test
    public void testContainsOperationSuccessfulWhenQuorumSizeMet() {
        cache1.containsKey((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testContainsOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.containsKey((Object)1);
    }

    @Test
    public void testGetAllOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        cache1.getAll(hashSet);
    }

    @Test(expected=QuorumException.class)
    public void testGetAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        cache4.getAll(hashSet);
    }

    @Test
    public void testIteratorOperationSuccessfulWhenQuorumSizeMet() {
        cache1.iterator();
    }

    @Test(expected=QuorumException.class)
    public void testIteratorOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.iterator();
    }

    @Test
    public void testGetAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.getAsync((Object)1);
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.getAsync((Object)1);
        foo.get();
    }
}

