/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.quorum.cache;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.quorum.QuorumTestUtil;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.quorum.PartitionedCluster;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheReadWriteQuorumTest
extends HazelcastTestSupport {
    private static final String CACHE_NAME_PREFIX = "cacheQuorum";
    private static final String QUORUM_ID = "threeNodeQuorumRule";
    static PartitionedCluster cluster;
    private static HazelcastClientCachingProvider cachingProvider1;
    private static HazelcastClientCachingProvider cachingProvider2;
    private static HazelcastClientCachingProvider cachingProvider3;
    private static HazelcastClientCachingProvider cachingProvider4;
    private static HazelcastClientCachingProvider cachingProvider5;
    private static HazelcastInstance c1;
    private static HazelcastInstance c2;
    private static HazelcastInstance c3;
    private static HazelcastInstance c4;
    private static HazelcastInstance c5;
    private static ICache<Integer, String> cache1;
    private static ICache<Integer, String> cache2;
    private static ICache<Integer, String> cache3;
    private static ICache<Integer, String> cache4;
    private static ICache<Integer, String> cache5;
    private static TestHazelcastFactory factory;

    @BeforeClass
    public static void initialize() throws Exception {
        QuorumConfig quorumConfig = new QuorumConfig();
        quorumConfig.setName(QUORUM_ID);
        quorumConfig.setType(QuorumType.READ_WRITE);
        quorumConfig.setEnabled(true);
        quorumConfig.setSize(3);
        CacheSimpleConfig cacheConfig = new CacheSimpleConfig();
        cacheConfig.setName("cacheQuorum*");
        cacheConfig.setQuorumName(QUORUM_ID);
        factory = new TestHazelcastFactory();
        cluster = new PartitionedCluster((TestHazelcastInstanceFactory)factory).createFiveMemberCluster(cacheConfig, quorumConfig);
        ClientCacheReadWriteQuorumTest.initializeClients();
        ClientCacheReadWriteQuorumTest.initializeCaches();
        cluster.splitFiveMembersThreeAndTwo();
        ClientCacheReadWriteQuorumTest.verifyClients();
    }

    private static void initializeClients() {
        c1 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadWriteQuorumTest.cluster.h1));
        c2 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadWriteQuorumTest.cluster.h2));
        c3 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadWriteQuorumTest.cluster.h3));
        c4 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadWriteQuorumTest.cluster.h4));
        c5 = factory.newHazelcastClient(QuorumTestUtil.getClientConfig(ClientCacheReadWriteQuorumTest.cluster.h5));
    }

    private static void initializeCaches() {
        cachingProvider1 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c1);
        cachingProvider2 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c2);
        cachingProvider3 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c3);
        cachingProvider4 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c4);
        cachingProvider5 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)c5);
        String cacheName = CACHE_NAME_PREFIX + ClientCacheReadWriteQuorumTest.randomString();
        cache1 = (ICache)cachingProvider1.getCacheManager().getCache(cacheName);
        cache2 = (ICache)cachingProvider2.getCacheManager().getCache(cacheName);
        cache3 = (ICache)cachingProvider3.getCacheManager().getCache(cacheName);
        cache4 = (ICache)cachingProvider4.getCacheManager().getCache(cacheName);
        cache5 = (ICache)cachingProvider5.getCacheManager().getCache(cacheName);
    }

    private static void verifyClients() {
        ClientCacheReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c1);
        ClientCacheReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c2);
        ClientCacheReadWriteQuorumTest.assertClusterSizeEventually((int)3, (HazelcastInstance)c3);
        ClientCacheReadWriteQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c4);
        ClientCacheReadWriteQuorumTest.assertClusterSizeEventually((int)2, (HazelcastInstance)c5);
    }

    @AfterClass
    public static void killAllHazelcastInstances() {
        factory.terminateAll();
    }

    @Test
    public void testGetOperationSuccessfulWhenQuorumSizeMet() {
        cache1.get((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testGetOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.get((Object)1);
    }

    @Test
    public void testPutOperationSuccessfulWhenQuorumSizeMet() {
        cache1.put((Object)1, (Object)"");
    }

    @Test(expected=QuorumException.class)
    public void testPutOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.put((Object)1, (Object)"");
    }

    @Test
    public void testContainsOperationSuccessfulWhenQuorumSizeMet() {
        cache1.containsKey((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testContainsOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.containsKey((Object)1);
    }

    @Test
    public void testGetAllOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        cache1.getAll(hashSet);
    }

    @Test(expected=QuorumException.class)
    public void testGetAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        cache4.getAll(hashSet);
    }

    @Test
    public void testGetAndPutOperationSuccessfulWhenQuorumSizeMet() {
        cache1.getAndPut((Object)1, (Object)"");
    }

    @Test(expected=QuorumException.class)
    public void testGetAndPutOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.getAndPut((Object)1, (Object)"");
    }

    @Test
    public void testGetAndRemoveOperationSuccessfulWhenQuorumSizeMet() {
        cache1.getAndRemove((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testGetAndRemoveOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.getAndRemove((Object)1);
    }

    @Test
    public void testGetAndReplaceOperationSuccessfulWhenQuorumSizeMet() {
        cache1.getAndReplace((Object)1, (Object)"");
    }

    @Test(expected=QuorumException.class)
    public void testGetAndReplaceOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.getAndReplace((Object)1, (Object)"");
    }

    @Test
    public void testClearOperationSuccessfulWhenQuorumSizeMet() {
        cache1.clear();
    }

    @Test(expected=QuorumException.class)
    public void testClearOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.clear();
    }

    @Test
    public void testIteratorOperationSuccessfulWhenQuorumSizeMet() {
        cache1.iterator();
    }

    @Test(expected=QuorumException.class)
    public void testIteratorOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.iterator();
    }

    @Test
    public void testPutIfAbsentOperationSuccessfulWhenQuorumSizeMet() {
        cache1.putIfAbsent((Object)1, (Object)"");
    }

    @Test(expected=QuorumException.class)
    public void testPutIfAbsentOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.putIfAbsent((Object)1, (Object)"");
    }

    @Test
    public void testPutAllOperationSuccessfulWhenQuorumSizeMet() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(123, "");
        cache1.putAll(hashMap);
    }

    @Test(expected=QuorumException.class)
    public void testPutAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(123, "");
        cache4.putAll(hashMap);
    }

    @Test
    public void testRemoveOperationSuccessfulWhenQuorumSizeMet() {
        cache1.remove((Object)1);
    }

    @Test(expected=QuorumException.class)
    public void testRemoveOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.remove((Object)1);
    }

    @Test
    public void testRemoveAllOperationSuccessfulWhenQuorumSizeMet() {
        cache1.removeAll();
    }

    @Test(expected=QuorumException.class)
    public void testRemoveAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.removeAll();
    }

    @Test
    public void testReplaceOperationSuccessfulWhenQuorumSizeMet() {
        cache1.replace((Object)1, (Object)"");
    }

    @Test(expected=QuorumException.class)
    public void testReplaceOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.replace((Object)1, (Object)"");
    }

    @Test
    public void testGetAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.getAsync((Object)1);
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.getAsync((Object)1);
        foo.get();
    }

    @Test
    public void testGetAndPutAsyncOperationSuccessfulWhenQuorumSizeMet() {
        cache1.getAndPutAsync((Object)1, (Object)"");
    }

    @Test(expected=ExecutionException.class)
    public void testGetAndPutAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.getAndPutAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test
    public void testGetAndRemoveAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.getAndRemoveAsync((Object)1);
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAndRemoveAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.getAndRemoveAsync((Object)1);
        foo.get();
    }

    @Test
    public void testGetAndReplaceAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.getAndReplaceAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetAndReplaceAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.getAndReplaceAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test
    public void testPutAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.putAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testPutAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.putAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test
    public void testPutIfAbsentAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.putIfAbsentAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testPutIfAbsentAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.putIfAbsentAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test
    public void testRemoveAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.removeAsync((Object)1);
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testRemoveAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.removeAsync((Object)1);
        foo.get();
    }

    @Test
    public void testReplaceAsyncOperationSuccessfulWhenQuorumSizeMet() throws Exception {
        ICompletableFuture foo = cache1.replaceAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test(expected=ExecutionException.class)
    public void testReplaceAsyncOperationThrowsExceptionWhenQuorumSizeNotMet() throws Exception {
        ICompletableFuture foo = cache4.replaceAsync((Object)1, (Object)"");
        foo.get();
    }

    @Test
    public void testInvokeOperationSuccessfulWhenQuorumSizeMet() {
        cache1.invoke((Object)123, (EntryProcessor)new SimpleEntryProcessor(), new Object[0]);
    }

    @Test(expected=EntryProcessorException.class)
    public void testInvokeOperationThrowsExceptionWhenQuorumSizeNotMet() {
        cache4.invoke((Object)123, (EntryProcessor)new SimpleEntryProcessor(), new Object[0]);
    }

    @Test
    public void testInvokeAllOperationSuccessfulWhenQuorumSizeMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        EntryProcessorResult epr = (EntryProcessorResult)cache1.invokeAll(hashSet, (EntryProcessor)new SimpleEntryProcessor(), new Object[0]).get(123);
        Assert.assertNull((Object)epr);
    }

    @Test(expected=EntryProcessorException.class)
    public void testInvokeAllOperationThrowsExceptionWhenQuorumSizeNotMet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(123);
        ((EntryProcessorResult)cache4.invokeAll(hashSet, (EntryProcessor)new SimpleEntryProcessor(), new Object[0]).get(123)).get();
    }

    public static class SimpleEntryProcessor
    implements EntryProcessor<Integer, String, Void>,
    Serializable {
        private static final long serialVersionUID = -396575576353368113L;

        public Void process(MutableEntry<Integer, String> entry, Object ... arguments) throws EntryProcessorException {
            entry.setValue((Object)"Foo");
            return null;
        }
    }
}

