/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReplicatedMapTest
extends HazelcastTestSupport {
    private static final int OPERATION_COUNT = 100;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testEmptyMapIsEmpty() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomName());
        Assert.assertTrue((String)"map should be empty", (boolean)map.isEmpty());
    }

    @Test
    public void testNonEmptyMapIsNotEmpty() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomName());
        map.put((Object)1, (Object)1);
        Assert.assertFalse((String)"map should not be empty", (boolean)map.isEmpty());
    }

    @Test
    public void testPutAll() throws TimeoutException {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = client.getReplicatedMap("default");
        ReplicatedMap map2 = server.getReplicatedMap("default");
        HashMap<String, String> mapTest = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            mapTest.put("foo-" + i, "bar");
        }
        map1.putAll(mapTest);
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
    }

    @Test
    public void testGetObjectDelay0() throws Exception {
        this.testGet(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testGetBinaryDelay0() throws Exception {
        this.testGet(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testGet(Config config) throws Exception {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)"bar", (Object)map1.get((Object)("foo-" + i)));
            Assert.assertEquals((Object)"bar", (Object)map2.get((Object)("foo-" + i)));
        }
    }

    @Test
    public void testPutNullReturnValueDeserialization() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomMapName());
        Assert.assertNull((Object)map.put((Object)1, (Object)2));
    }

    @Test
    public void testPutReturnValueDeserialization() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = client.getReplicatedMap(ClientReplicatedMapTest.randomMapName());
        map.put((Object)1, (Object)2);
        Assert.assertEquals((Object)2, (Object)map.put((Object)1, (Object)3));
    }

    @Test
    public void testAddObjectDelay0() throws Exception {
        this.testAdd(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testAddBinaryDelay0() throws Exception {
        this.testAdd(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testAdd(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
    }

    @Test
    public void testClearObjectDelay0() throws Exception {
        this.testClear(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testClearBinaryDelay0() throws Exception {
        this.testClear(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testClear(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        map1.clear();
        Assert.assertEquals((long)0L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
    }

    @Test
    public void testUpdateObjectDelay0() throws Exception {
        this.testUpdate(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testUpdateBinaryDelay0() throws Exception {
        this.testUpdate(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testUpdate(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (int i = 0; i < 100; ++i) {
            map2.put((Object)("foo-" + i), (Object)"bar2");
        }
        for (Map.Entry entry : map2.entrySet()) {
            Assert.assertEquals((Object)"bar2", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            Assert.assertEquals((Object)"bar2", entry.getValue());
        }
    }

    @Test
    public void testRemoveObjectDelay0() throws Exception {
        this.testRemove(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testRemoveBinaryDelay0() throws Exception {
        this.testRemove(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testRemove(Config config) throws Exception {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (int i2 = 0; i2 < 100; ++i2) {
            map1.put((Object)("foo-" + i2), (Object)"bar");
        }
        for (Map.Entry entry : map2.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (Map.Entry entry : map1.entrySet()) {
            ClientReplicatedMapTest.assertStartsWith((String)"foo-", (String)((String)entry.getKey()));
            Assert.assertEquals((Object)"bar", entry.getValue());
        }
        for (i = 0; i < 100; ++i) {
            map2.remove((Object)("foo-" + i));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map2.get((Object)("foo-" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertNull((Object)map1.get((Object)("foo-" + i)));
        }
    }

    @Test
    public void testSizeObjectDelay0() throws Exception {
        this.testSize(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testSizeBinaryDelay0() throws Exception {
        this.testSize(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testSize(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = this.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        Assert.assertEquals((long)testValues.length, (long)map1.size());
        Assert.assertEquals((long)testValues.length, (long)map2.size());
    }

    @Test
    public void testContainsKeyObjectDelay0() throws Exception {
        this.testContainsKey(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testContainsKeyBinaryDelay0() throws Exception {
        this.testContainsKey(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testContainsKey(Config config) throws Exception {
        int i;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        for (i = 0; i < 100; ++i) {
            map1.put((Object)("foo-" + i), (Object)"bar");
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)map2.containsKey((Object)("foo-" + i)));
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)map1.containsKey((Object)("foo-" + i)));
        }
    }

    @Test
    public void testContainsValueObjectDelay0() throws Exception {
        this.testContainsValue(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testContainsValueBinaryDelay0() throws Exception {
        this.testContainsValue(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testContainsValue(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = this.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        for (AbstractMap.SimpleEntry<Integer, Integer> testValue : testValues) {
            Assert.assertTrue((boolean)map2.containsValue((Object)testValue.getValue()));
        }
        boolean map1Contains = false;
        for (AbstractMap.SimpleEntry<Integer, Integer> testValue : testValues) {
            Assert.assertTrue((boolean)map1.containsValue((Object)testValue.getValue()));
        }
    }

    @Test
    public void testValuesObjectDelay0() throws Exception {
        this.testValues(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testValuesBinaryDelay0() throws Exception {
        this.testValues(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testValues(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = this.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet values1 = new HashSet(map1.values());
        HashSet values2 = new HashSet(map2.values());
        for (AbstractMap.SimpleEntry<Integer, Integer> e : testValues) {
            ClientReplicatedMapTest.assertContains(values1, (Object)e.getValue());
            ClientReplicatedMapTest.assertContains(values2, (Object)e.getValue());
        }
    }

    @Test
    public void testKeySetObjectDelay0() throws Exception {
        this.testKeySet(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testKeySetBinaryDelay0() throws Exception {
        this.testKeySet(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testKeySet(Config config) throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = this.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet keys1 = new HashSet(map1.keySet());
        HashSet keys2 = new HashSet(map2.keySet());
        for (AbstractMap.SimpleEntry<Integer, Integer> e : testValues) {
            ClientReplicatedMapTest.assertContains(keys1, (Object)e.getKey());
            ClientReplicatedMapTest.assertContains(keys2, (Object)e.getKey());
        }
    }

    @Test
    public void testEntrySetObjectDelay0() throws Exception {
        this.testEntrySet(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testEntrySetBinaryDelay0() throws Exception {
        this.testEntrySet(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testEntrySet(Config config) throws Exception {
        Integer value;
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map1 = instance1.getReplicatedMap("default");
        ReplicatedMap map2 = instance2.getReplicatedMap("default");
        AbstractMap.SimpleEntry<Integer, Integer>[] testValues = this.buildTestValues();
        int half = testValues.length / 2;
        for (int i = 0; i < testValues.length; ++i) {
            ReplicatedMap map = i < half ? map1 : map2;
            AbstractMap.SimpleEntry<Integer, Integer> entry = testValues[i];
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        HashSet entrySet1 = new HashSet(map1.entrySet());
        HashSet entrySet2 = new HashSet(map2.entrySet());
        for (Map.Entry entry : entrySet2) {
            value = this.findValue((Integer)entry.getKey(), testValues);
            Assert.assertEquals((Object)value, entry.getValue());
        }
        for (Map.Entry entry : entrySet1) {
            value = this.findValue((Integer)entry.getKey(), testValues);
            Assert.assertEquals((Object)value, entry.getValue());
        }
    }

    @Test
    public void testRetrieveUnknownValueObjectDelay0() {
        this.testRetrieveUnknownValue(this.buildConfig(InMemoryFormat.OBJECT, 0L));
    }

    @Test
    public void testRetrieveUnknownValueBinaryDelay0() {
        this.testRetrieveUnknownValue(this.buildConfig(InMemoryFormat.BINARY, 0L));
    }

    private void testRetrieveUnknownValue(Config config) {
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastClient();
        ReplicatedMap map = instance.getReplicatedMap("default");
        String value = (String)map.get((Object)"foo");
        Assert.assertNull((Object)value);
    }

    @Test
    public void testNearCacheInvalidation() {
        String mapName = ClientReplicatedMapTest.randomString();
        ClientConfig config = this.getClientConfigWithNearCacheInvalidationEnabled();
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient(config);
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient(config);
        final ReplicatedMap replicatedMap1 = client1.getReplicatedMap(mapName);
        replicatedMap1.put((Object)1, (Object)1);
        replicatedMap1.get((Object)1);
        ReplicatedMap replicatedMap2 = client2.getReplicatedMap(mapName);
        replicatedMap2.put((Object)1, (Object)2);
        ClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)((Integer)replicatedMap1.get((Object)1)).intValue());
            }
        });
    }

    @Test
    public void testNearCacheInvalidation_withClear() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = this.getClientConfigWithNearCacheInvalidationEnabled();
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient(config);
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient(config);
        String mapName = ClientReplicatedMapTest.randomString();
        final ReplicatedMap replicatedMap1 = client1.getReplicatedMap(mapName);
        replicatedMap1.put((Object)1, (Object)1);
        replicatedMap1.get((Object)1);
        ReplicatedMap replicatedMap2 = client2.getReplicatedMap(mapName);
        replicatedMap2.clear();
        ClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals(null, (Object)replicatedMap1.get((Object)1));
            }
        });
    }

    @Test
    public void testClientPortableWithoutRegisteringToNode() {
        this.hazelcastFactory.newHazelcastInstance(this.buildConfig(InMemoryFormat.BINARY, 0L));
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addPortableFactory(5, new PortableFactory(){

            public Portable create(int classId) {
                return new SamplePortable();
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setSerializationConfig(serializationConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap sampleMap = client.getReplicatedMap(ClientReplicatedMapTest.randomString());
        sampleMap.put((Object)1, (Object)new SamplePortable(666));
        SamplePortable samplePortable = (SamplePortable)sampleMap.get((Object)1);
        Assert.assertEquals((long)666L, (long)samplePortable.a);
    }

    private ClientConfig getClientConfigWithNearCacheInvalidationEnabled() {
        ClientConfig config = new ClientConfig();
        NearCacheConfig nnc = new NearCacheConfig();
        nnc.setInvalidateOnChange(true);
        nnc.setInMemoryFormat(InMemoryFormat.OBJECT);
        config.addNearCacheConfig(nnc);
        return config;
    }

    private Config buildConfig(InMemoryFormat inMemoryFormat, long replicationDelay) {
        Config config = new Config();
        ReplicatedMapConfig replicatedMapConfig = config.getReplicatedMapConfig("default");
        replicatedMapConfig.setReplicationDelayMillis(replicationDelay);
        replicatedMapConfig.setInMemoryFormat(inMemoryFormat);
        return config;
    }

    private Integer findValue(int key, AbstractMap.SimpleEntry<Integer, Integer>[] values) {
        for (AbstractMap.SimpleEntry<Integer, Integer> value : values) {
            if (!value.getKey().equals(key)) continue;
            return value.getValue();
        }
        return null;
    }

    private AbstractMap.SimpleEntry<Integer, Integer>[] buildTestValues() {
        Random random = new Random();
        AbstractMap.SimpleEntry[] testValues = new AbstractMap.SimpleEntry[100];
        for (int i = 0; i < testValues.length; ++i) {
            testValues[i] = new AbstractMap.SimpleEntry<Integer, Integer>(random.nextInt(), random.nextInt());
        }
        return testValues;
    }

    static class SamplePortable
    implements Portable {
        public int a;

        SamplePortable(int a) {
            this.a = a;
        }

        SamplePortable() {
        }

        public int getFactoryId() {
            return 5;
        }

        public int getClassId() {
            return 6;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("a", this.a);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.a = reader.readInt("a");
        }
    }
}

