/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.nio.Address;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class DummyClientReplicatedMapTest
extends HazelcastTestSupport {
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testGet() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance2.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    @Test
    public void testIsEmpty() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertFalse((boolean)map.isEmpty());
            }
        });
    }

    @Test
    public void testKeySet() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        final String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        String value = DummyClientReplicatedMapTest.randomString();
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Set keySet = map.keySet();
                Assert.assertEquals((long)1L, (long)keySet.size());
                Assert.assertEquals((Object)key, keySet.iterator().next());
            }
        });
    }

    @Test
    public void testEntrySet() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        final String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        final String value = DummyClientReplicatedMapTest.randomString();
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Set entries = map.entrySet();
                Assert.assertEquals((long)1L, (long)entries.size());
                Map.Entry entry = (Map.Entry)entries.iterator().next();
                Assert.assertEquals((Object)key, entry.getKey());
                Assert.assertEquals((Object)value, entry.getValue());
            }
        });
    }

    @Test
    public void testValues() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        final String value = DummyClientReplicatedMapTest.randomString();
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Collection values = map.values();
                Assert.assertEquals((long)1L, (long)values.size());
                Assert.assertEquals((Object)value, values.iterator().next());
            }
        });
    }

    @Test
    public void testContainsKey() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        Assert.assertTrue((boolean)map.containsKey((Object)key));
    }

    @Test
    public void testContainsValue() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        final String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)map.containsValue((Object)value));
            }
        });
    }

    @Test
    public void testSize() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)map.size());
            }
        });
    }

    @Test
    public void testClear() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        map.clear();
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)map.size());
            }
        });
    }

    @Test
    public void testRemove() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        final ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        map.put((Object)key, (Object)value);
        map.remove((Object)key);
        DummyClientReplicatedMapTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)map.size());
            }
        });
    }

    @Test
    public void testPutAll() throws Exception {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig(instance1));
        ReplicatedMap map = client.getReplicatedMap(DummyClientReplicatedMapTest.randomMapName());
        String key = DummyClientReplicatedMapTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        int partitionId = instance1.getPartitionService().getPartition((Object)key).getPartitionId();
        this.setPartitionId((ReplicatedMap<String, String>)map, partitionId);
        String value = DummyClientReplicatedMapTest.randomString();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key, value);
        map.putAll(m);
        Assert.assertEquals((Object)value, (Object)map.get((Object)key));
    }

    private ClientConfig getClientConfig(HazelcastInstance instance) {
        Address address = instance.getCluster().getLocalMember().getAddress();
        String addressString = address.getHost() + ":" + address.getPort();
        ClientConfig dummyClientConfig = new ClientConfig();
        ClientNetworkConfig networkConfig = new ClientNetworkConfig();
        networkConfig.setSmartRouting(false);
        networkConfig.addAddress(new String[]{addressString});
        dummyClientConfig.setNetworkConfig(networkConfig);
        return dummyClientConfig;
    }

    private void setPartitionId(ReplicatedMap<String, String> map, int partitionId) throws Exception {
        Class<?> clazz = map.getClass();
        Field targetPartitionId = clazz.getDeclaredField("targetPartitionId");
        targetPartitionId.setAccessible(true);
        targetPartitionId.setInt(map, partitionId);
    }
}

