/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap.nearcache;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ReplicatedMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.AbstractBasicNearCacheTest;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.NearCacheTestContext;
import com.hazelcast.internal.nearcache.NearCacheTestUtils;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.test.HazelcastParametersRunnerFactory;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParametersRunnerFactory.class)
@Category(value={QuickTest.class})
public class BasicClientReplicatedMapNearCacheTest
extends AbstractBasicNearCacheTest<Data, String> {
    @Parameterized.Parameter
    public InMemoryFormat inMemoryFormat;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Parameterized.Parameters(name="format:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({InMemoryFormat.BINARY}, {InMemoryFormat.OBJECT});
    }

    @Before
    public void setUp() {
        this.nearCacheConfig = NearCacheTestUtils.createNearCacheConfig((InMemoryFormat)this.inMemoryFormat);
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected <K, V> NearCacheTestContext<K, V, Data, String> createContext() {
        Config config = this.getConfig();
        config.getReplicatedMapConfig("defaultNearCache").setInMemoryFormat(this.nearCacheConfig.getInMemoryFormat());
        ClientConfig clientConfig = this.getClientConfig().addNearCacheConfig(this.nearCacheConfig);
        HazelcastInstance member = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastClientProxy client = (HazelcastClientProxy)this.hazelcastFactory.newHazelcastClient(clientConfig);
        ReplicatedMap memberMap = member.getReplicatedMap("defaultNearCache");
        ReplicatedMap clientMap = client.getReplicatedMap("defaultNearCache");
        NearCacheManager nearCacheManager = client.client.getNearCacheManager();
        NearCache nearCache = nearCacheManager.getNearCache("defaultNearCache");
        return new NearCacheTestContext(client.getSerializationService(), (HazelcastInstance)client, member, (DataStructureAdapter)new ReplicatedMapDataStructureAdapter(clientMap), (DataStructureAdapter)new ReplicatedMapDataStructureAdapter(memberMap), false, nearCache, nearCacheManager);
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    @Test
    @Ignore(value="The ClientReplicatedMapProxy is missing `invalidateNearCache(keyData)` calls")
    public void whenCacheIsFull_thenPutOnSameKeyShouldUpdateValue_withUpdateOnNearCacheAdapter() {
    }

    @Test
    @Ignore(value="The ClientReplicatedMapProxy is missing `invalidateNearCache(keyData)` calls")
    public void whenPutAllIsUsed_thenNearCacheShouldBeInvalidated_withUpdateOnNearCacheAdapter() {
    }
}

