/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ProxyFactoryTest {
    private static final String SERVICE_NAME = "CustomService";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        Config config = new Config();
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setEnabled(true).setName(SERVICE_NAME).setImplementation((Object)new CustomService());
        config.getServicesConfig().addServiceConfig(serviceConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
    }

    @Test
    public void testCustomProxy_usingFactoryClassName() {
        ClientConfig clientConfig = new ClientConfig();
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig();
        proxyFactoryConfig.setService(SERVICE_NAME);
        proxyFactoryConfig.setClassName(CustomProxyFactory.class.getName());
        clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
        this.testCustomProxy(clientConfig);
    }

    @Test
    public void testCustomProxy_usingFactoryImplementation() {
        ClientConfig clientConfig = new ClientConfig();
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig();
        proxyFactoryConfig.setService(SERVICE_NAME);
        proxyFactoryConfig.setFactoryImpl((ClientProxyFactory)new CustomProxyFactory());
        clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
        this.testCustomProxy(clientConfig);
    }

    private void testCustomProxy(ClientConfig clientConfig) {
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        String objectName = "custom-object";
        CustomClientProxy proxy = (CustomClientProxy)client.getDistributedObject(SERVICE_NAME, objectName);
        Assert.assertEquals((Object)SERVICE_NAME, (Object)proxy.getServiceName());
        Assert.assertEquals((Object)objectName, (Object)proxy.getName());
    }

    @Test
    public void testProxy_whenInitThrowsError() {
        ClientConfig clientConfig = new ClientConfig();
        ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig();
        proxyFactoryConfig.setService(SERVICE_NAME);
        proxyFactoryConfig.setFactoryImpl(new ClientProxyFactory(){

            public ClientProxy create(String id) {
                return new ClientProxy(ProxyFactoryTest.SERVICE_NAME, id){

                    protected void onInitialize() {
                        super.onInitialize();
                        throw new ExpectedError();
                    }
                };
            }
        });
        clientConfig.addProxyFactoryConfig(proxyFactoryConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        String objectName = "custom-object";
        try {
            client.getDistributedObject(SERVICE_NAME, objectName);
            Assert.fail((String)"Client proxy initialization should fail!");
        }
        catch (ExpectedError expectedError) {
            // empty catch block
        }
    }

    private static class CustomClientProxy
    extends ClientProxy {
        protected CustomClientProxy(String serviceName, String objectName) {
            super(serviceName, objectName);
        }
    }

    private static class CustomProxyFactory
    implements ClientProxyFactory {
        private CustomProxyFactory() {
        }

        public ClientProxy create(String id) {
            return new CustomClientProxy(ProxyFactoryTest.SERVICE_NAME, id);
        }
    }

    private static class CustomService
    implements RemoteService {
        private CustomService() {
        }

        public DistributedObject createDistributedObject(String objectName) {
            return new CustomClientProxy(ProxyFactoryTest.SERVICE_NAME, objectName);
        }

        public void destroyDistributedObject(String objectName) {
        }
    }

    private static class ExpectedError
    extends Error {
        private ExpectedError() {
        }
    }
}

