/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientInvocationTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void executionCallback_TooLongThrowableStackTrace() throws InterruptedException {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(ClientInvocationTest.randomMapName());
        DummyEntryProcessor ep = new DummyEntryProcessor();
        int count = 100;
        FailureExecutionCallback[] callbacks = new FailureExecutionCallback[count];
        String key = ClientInvocationTest.randomString();
        for (int i = 0; i < count; ++i) {
            callbacks[i] = new FailureExecutionCallback();
            map.submitToKey((Object)key, (EntryProcessor)ep, (ExecutionCallback)callbacks[i]);
        }
        TestUtil.getNode((HazelcastInstance)server).getConnectionManager().shutdown();
        server.getLifecycleService().terminate();
        int callBackCount = 0;
        for (FailureExecutionCallback callback : callbacks) {
            ClientInvocationTest.assertOpenEventually((String)("Callback should be notified on time! callbackCount:" + ++callBackCount), (CountDownLatch)callback.latch);
            Throwable failure = callback.failure;
            if (failure == null) continue;
            int stackTraceLength = failure.getStackTrace().length;
            Assert.assertTrue((String)("Failure stack trace should not be too long! Current: " + stackTraceLength), (stackTraceLength < 50 ? 1 : 0) != 0);
            Throwable cause = failure.getCause();
            if (cause == null) continue;
            stackTraceLength = cause.getStackTrace().length;
            Assert.assertTrue((String)("Cause stack trace should not be too long! Current: " + stackTraceLength), (stackTraceLength < 50 ? 1 : 0) != 0);
        }
    }

    @Test
    public void executionCallback_FailOnShutdown() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        IMap map = client.getMap(ClientInvocationTest.randomName());
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
                    disconnectedLatch.countDown();
                }
            }
        });
        server.shutdown();
        ClientInvocationTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        int n = 100;
        final CountDownLatch errorLatch = new CountDownLatch(n);
        for (int i = 0; i < n; ++i) {
            try {
                map.submitToKey((Object)ClientInvocationTest.randomString(), (EntryProcessor)new DummyEntryProcessor(), new ExecutionCallback(){

                    public void onResponse(Object response) {
                    }

                    public void onFailure(Throwable t) {
                        errorLatch.countDown();
                    }
                });
                continue;
            }
            catch (Exception e) {
                errorLatch.countDown();
            }
        }
        ClientInvocationTest.assertOpenEventually((String)"Not all of the requests failed", (CountDownLatch)errorLatch);
    }

    private static class FailureExecutionCallback
    implements ExecutionCallback {
        final CountDownLatch latch = new CountDownLatch(1);
        volatile Throwable failure;

        private FailureExecutionCallback() {
        }

        public void onResponse(Object response) {
            this.latch.countDown();
        }

        public void onFailure(Throwable t) {
            this.failure = t;
            this.latch.countDown();
        }
    }

    private static class DummyEntryProcessor
    implements EntryProcessor {
        private DummyEntryProcessor() {
        }

        public Object process(Map.Entry entry) {
            LockSupport.parkNanos(10000L);
            return null;
        }

        public EntryBackupProcessor getBackupProcessor() {
            return null;
        }
    }
}

