/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.discovery.multicast.MulticastDiscoveryStrategy;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.InputStream;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientToMemberDiscoveryTest
extends HazelcastTestSupport {
    Config serverConfig;
    ClientConfig clientConfig;
    HazelcastInstance instance1;
    HazelcastInstance instance2;
    public final TestHazelcastFactory factory = new TestHazelcastFactory();

    @Before
    public void setup() {
        String serverXmlFileName = "hazelcast-multicast-plugin.xml";
        String clientXmlFileName = "hazelcast-client-multicast-plugin.xml";
        InputStream xmlResource = MulticastDiscoveryStrategy.class.getClassLoader().getResourceAsStream(serverXmlFileName);
        this.serverConfig = new XmlConfigBuilder(xmlResource).build();
        InputStream xmlClientResource = MulticastDiscoveryStrategy.class.getClassLoader().getResourceAsStream(clientXmlFileName);
        this.clientConfig = new XmlClientConfigBuilder(xmlClientResource).build();
    }

    @Test
    public void clientTest() {
        this.instance1 = this.factory.newHazelcastInstance(this.serverConfig);
        this.instance2 = this.factory.newHazelcastInstance(this.serverConfig);
        final HazelcastInstance client = this.factory.newHazelcastClient(this.clientConfig);
        ClientToMemberDiscoveryTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Set members = client.getCluster().getMembers();
                Assert.assertEquals((long)2L, (long)members.size());
            }
        });
        this.factory.shutdownAll();
    }
}

