/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.standalone;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.standalone.model.MyElement;
import com.hazelcast.client.standalone.model.MyKey;
import com.hazelcast.client.standalone.model.MyPortableElement;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.FilteringClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientMapStandaloneTest {
    private static final ClassLoader FILTERING_CLASS_LOADER;
    static HazelcastInstance client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(FILTERING_CLASS_LOADER);
        try {
            Class<?> configClazz = FILTERING_CLASS_LOADER.loadClass("com.hazelcast.config.Config");
            Object config = configClazz.newInstance();
            Method setClassLoader = configClazz.getDeclaredMethod("setClassLoader", ClassLoader.class);
            setClassLoader.invoke(config, FILTERING_CLASS_LOADER);
            Class<?> hazelcastClazz = FILTERING_CLASS_LOADER.loadClass("com.hazelcast.core.Hazelcast");
            Method newHazelcastInstance = hazelcastClazz.getDeclaredMethod("newHazelcastInstance", configClazz);
            newHazelcastInstance.invoke(hazelcastClazz, config);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(1, (PortableFactory)new MyPortableElement.Factory());
        client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    public IMap createMap() {
        return client.getMap(HazelcastTestSupport.randomString());
    }

    @AfterClass
    public static void destroy() throws Exception {
        client.shutdown();
        Class<?> hazelcastClazz = FILTERING_CLASS_LOADER.loadClass("com.hazelcast.core.Hazelcast");
        Method shutdownAll = hazelcastClazz.getDeclaredMethod("shutdownAll", new Class[0]);
        shutdownAll.invoke(hazelcastClazz, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPut() throws Exception {
        MyKey key = new MyKey();
        MyElement element = new MyElement(HazelcastTestSupport.randomString());
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(FILTERING_CLASS_LOADER);
        try {
            IMap map = this.createMap();
            map.put((Object)key, (Object)element);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet() throws Exception {
        IMap map = this.createMap();
        MyKey key = new MyKey();
        MyElement element = new MyElement(HazelcastTestSupport.randomString());
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(FILTERING_CLASS_LOADER);
        try {
            map.put((Object)key, (Object)element);
            MyElement result = (MyElement)map.get((Object)key);
            Assert.assertEquals((Object)element, (Object)result);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemove() throws Exception {
        IMap map = this.createMap();
        MyKey key = new MyKey();
        MyElement element = new MyElement(HazelcastTestSupport.randomString());
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(FILTERING_CLASS_LOADER);
        try {
            map.put((Object)key, (Object)element);
            MyElement result = (MyElement)map.remove((Object)key);
            Assert.assertEquals((Object)element, (Object)result);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClear() throws Exception {
        IMap map = this.createMap();
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(FILTERING_CLASS_LOADER);
        try {
            MyKey key = new MyKey();
            MyElement element = new MyElement(HazelcastTestSupport.randomString());
            map.put((Object)key, (Object)element);
            map.clear();
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    @Test
    public void testPortable_withEntryListenerWithPredicate() throws Exception {
        int key = 1;
        int id = 1;
        IMap map = this.createMap();
        Predicate predicate = Predicates.equal((String)"id", (Comparable)Integer.valueOf(id));
        MyPortableElement element = new MyPortableElement(id);
        final CountDownLatch eventLatch = new CountDownLatch(1);
        map.addEntryListener((EntryListener)new EntryAdapter<Integer, MyPortableElement>(){

            public void onEntryEvent(EntryEvent<Integer, MyPortableElement> event) {
                eventLatch.countDown();
            }
        }, predicate, true);
        map.put((Object)key, (Object)element);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)eventLatch);
        Collection values = map.values(Predicates.lessThan((String)"date", (Comparable)Long.valueOf(new Date().getTime())));
        Assert.assertEquals(values.iterator().next(), (Object)element);
    }

    @Test
    public void testPortable_query_with_index() throws Exception {
        IMap map = this.createMap();
        for (int i = 0; i < 100; ++i) {
            MyPortableElement element = new MyPortableElement(i);
            map.put((Object)i, (Object)element);
        }
        map.addIndex("id", false);
        Predicate predicate = Predicates.or((Predicate[])new Predicate[]{Predicates.equal((String)"id", (Comparable)Integer.valueOf(0)), Predicates.equal((String)"id", (Comparable)Integer.valueOf(1))});
        Collection values = map.values(predicate);
        Assert.assertEquals((long)2L, (long)values.size());
    }

    @Test
    public void testRemoveAllWithPredicate_DoesNotDeserializeValues() {
        MyPortableElement entry;
        int i;
        IMap map = this.createMap();
        for (int i2 = 0; i2 < 100; ++i2) {
            map.put((Object)i2, (Object)new MyPortableElement(i2));
        }
        Predicate predicate = Predicates.in((String)"id", (Comparable[])new Comparable[]{Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)});
        map.removeAll(predicate);
        for (i = 0; i < 10; ++i) {
            entry = (MyPortableElement)map.get((Object)i);
            Assert.assertNull((Object)entry);
        }
        for (i = 10; i < 100; ++i) {
            entry = (MyPortableElement)map.get((Object)i);
            Assert.assertNotNull((Object)entry);
        }
    }

    static {
        List<String> excludes = Arrays.asList("com.hazelcast.client.standalone.model");
        FILTERING_CLASS_LOADER = new FilteringClassLoader(excludes, "com.hazelcast");
    }
}

