/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.stress;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.stress.StressTestSupport;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class AtomicLongStableReadStressTest
extends StressTestSupport {
    public static final int CLIENT_THREAD_COUNT = 5;
    public static final int REFERENCE_COUNT = 10000;
    private HazelcastInstance client;
    private IAtomicLong[] references;
    private StressThread[] stressThreads;

    @Override
    @Before
    public void setUp() {
        int k;
        super.setUp();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.references = new IAtomicLong[10000];
        for (k = 0; k < this.references.length; ++k) {
            this.references[k] = this.client.getAtomicLong("atomicreference:" + k);
        }
        this.stressThreads = new StressThread[5];
        for (k = 0; k < this.stressThreads.length; ++k) {
            this.stressThreads[k] = new StressThread();
            this.stressThreads[k].start();
        }
    }

    @Override
    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.shutdown();
        }
        super.tearDown();
    }

    @Test
    public void testChangingCluster() {
        this.test(true);
    }

    @Test(timeout=600000L)
    public void testFixedCluster() {
        this.test(false);
    }

    public void test(boolean clusterChangeEnabled) {
        this.setClusterChangeEnabled(clusterChangeEnabled);
        this.initializeReferences();
        this.startAndWaitForTestCompletion();
        this.joinAll(this.stressThreads);
    }

    private void initializeReferences() {
        System.out.println("==================================================================");
        System.out.println("Initializing references");
        System.out.println("==================================================================");
        for (int k = 0; k < this.references.length; ++k) {
            this.references[k].set((long)k);
        }
        System.out.println("==================================================================");
        System.out.println("Completed with initializing references");
        System.out.println("==================================================================");
    }

    public class StressThread
    extends StressTestSupport.TestThread {
        @Override
        public void doRun() throws Exception {
            while (!AtomicLongStableReadStressTest.this.isStopped()) {
                int key = this.random.nextInt(10000);
                IAtomicLong reference = AtomicLongStableReadStressTest.this.references[key];
                long value = reference.get();
                Assert.assertEquals((String)String.format("The value for atomic reference: %s was not consistent", reference), (long)key, (long)value);
            }
        }
    }
}

