/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestClientRegistry;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.Address;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastTestSupport;
import org.junit.Assert;

public class ClientTestSupport
extends HazelcastTestSupport {
    protected void blockMessagesFromInstance(HazelcastInstance instance, HazelcastInstance client) {
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        Address address = instance.getCluster().getLocalMember().getAddress();
        ((TestClientRegistry.MockClientConnectionManager)connectionManager).blockFrom(address);
    }

    protected void unblockMessagesFromInstance(HazelcastInstance instance, HazelcastInstance client) {
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        Address address = instance.getCluster().getLocalMember().getAddress();
        ((TestClientRegistry.MockClientConnectionManager)connectionManager).unblockFrom(address);
    }

    protected void blockMessagesToInstance(HazelcastInstance instance, HazelcastInstance client) {
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        Address address = instance.getCluster().getLocalMember().getAddress();
        ((TestClientRegistry.MockClientConnectionManager)connectionManager).blockTo(address);
    }

    protected void unblockMessagesToInstance(HazelcastInstance instance, HazelcastInstance client) {
        HazelcastClientInstanceImpl clientImpl = this.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        Address address = instance.getCluster().getLocalMember().getAddress();
        ((TestClientRegistry.MockClientConnectionManager)connectionManager).unblockTo(address);
    }

    protected HazelcastClientInstanceImpl getHazelcastClientInstanceImpl(HazelcastInstance client) {
        HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
        return clientProxy.client;
    }

    protected HazelcastInstance getOwnerServer(TestHazelcastFactory factory, HazelcastClientInstanceImpl client) {
        Address ownerConnectionAddress = client.getClientClusterService().getOwnerConnectionAddress();
        return factory.getInstance(ownerConnectionAddress);
    }

    protected void makeSureConnectedToServers(final HazelcastInstance client, final int numberOfServers) {
        ClientTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                ClientConnectionManager connectionManager = ClientTestSupport.this.getHazelcastClientInstanceImpl(client).getConnectionManager();
                Assert.assertEquals((long)numberOfServers, (long)connectionManager.getActiveConnections().size());
            }
        });
    }
}

