/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientProtocolBuffer;
import com.hazelcast.client.spi.impl.AwsAddressTranslator;
import com.hazelcast.client.spi.impl.DefaultAddressTranslator;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressTranslator;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TwoWayBlockableExecutor;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.test.mocknetwork.MockConnection;
import com.hazelcast.test.mocknetwork.TestNodeRegistry;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

class TestClientRegistry {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastClient.class);
    private final TestNodeRegistry nodeRegistry;

    TestClientRegistry(TestNodeRegistry nodeRegistry) {
        this.nodeRegistry = nodeRegistry;
    }

    ClientConnectionManagerFactory createClientServiceFactory(String host, AtomicInteger ports) {
        return new MockClientConnectionManagerFactory(host, ports);
    }

    private class MockedNodeConnection
    extends MockConnection {
        private final MockedClientConnection responseConnection;
        private final int connectionId;
        private volatile long lastReadTimeMillis;
        private volatile long lastWriteTimeMillis;
        private volatile AtomicBoolean alive;

        MockedNodeConnection(int connectionId, Address localEndpoint, Address remoteEndpoint, NodeEngineImpl nodeEngine, MockedClientConnection responseConnection) {
            super(localEndpoint, remoteEndpoint, nodeEngine);
            this.alive = new AtomicBoolean(true);
            this.responseConnection = responseConnection;
            this.connectionId = connectionId;
            this.register();
            this.lastReadTimeMillis = System.currentTimeMillis();
            this.lastWriteTimeMillis = System.currentTimeMillis();
        }

        private void register() {
            Node node = this.nodeEngine.getNode();
            node.getConnectionManager().registerConnection(this.getEndPoint(), (Connection)this);
        }

        public boolean write(OutboundFrame frame) {
            ClientMessage packet = (ClientMessage)frame;
            if (this.isAlive()) {
                this.lastWriteTimeMillis = System.currentTimeMillis();
                ClientMessage newPacket = this.readFromPacket(packet);
                this.responseConnection.handleClientMessage(newPacket);
                return true;
            }
            return false;
        }

        void handleClientMessage(ClientMessage newPacket) {
            this.lastReadTimeMillis = System.currentTimeMillis();
            this.nodeEngine.getNode().clientEngine.handleClientMessage(newPacket, (Connection)this);
        }

        public boolean isClient() {
            return true;
        }

        private ClientMessage readFromPacket(ClientMessage packet) {
            return ClientMessage.createForDecode((ClientProtocolBuffer)packet.buffer(), (int)0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MockedNodeConnection that = (MockedNodeConnection)((Object)o);
            if (this.connectionId != that.connectionId) {
                return false;
            }
            Address remoteEndpoint = this.getEndPoint();
            return !(remoteEndpoint == null ? that.getEndPoint() != null : !remoteEndpoint.equals((Object)that.getEndPoint()));
        }

        public void close(String reason, Throwable cause) {
            if (!this.alive.compareAndSet(true, false)) {
                return;
            }
            Logger.getLogger(MockedNodeConnection.class).warning("Server connection closed : " + reason, cause);
            super.close(reason, cause);
            this.responseConnection.onServerClose(reason);
        }

        public int hashCode() {
            int result = this.connectionId;
            Address remoteEndpoint = this.getEndPoint();
            result = 31 * result + (remoteEndpoint != null ? remoteEndpoint.hashCode() : 0);
            return result;
        }

        public long lastReadTimeMillis() {
            return this.lastReadTimeMillis;
        }

        public long lastWriteTimeMillis() {
            return this.lastWriteTimeMillis;
        }

        public ConnectionType getType() {
            return ConnectionType.JAVA_CLIENT;
        }

        public String toString() {
            return "MockedNodeConnection{ remoteEndpoint = " + this.getEndPoint() + ", localEndpoint = " + this.localEndpoint + ", connectionId = " + this.connectionId + '}';
        }
    }

    private class MockedClientConnection
    extends ClientConnection {
        private volatile long lastReadTime;
        private volatile long lastWriteTime;
        private final NodeEngineImpl serverNodeEngine;
        private final Address remoteAddress;
        private final Address localAddress;
        private final MockedNodeConnection serverSideConnection;
        private final TwoWayBlockableExecutor executor;

        MockedClientConnection(HazelcastClientInstanceImpl client, int connectionId, NodeEngineImpl serverNodeEngine, Address address, Address localAddress, TwoWayBlockableExecutor.LockPair lockPair) throws IOException {
            super(client, connectionId);
            this.serverNodeEngine = serverNodeEngine;
            this.remoteAddress = address;
            this.localAddress = localAddress;
            this.executor = new TwoWayBlockableExecutor(lockPair);
            this.serverSideConnection = new MockedNodeConnection(connectionId, this.remoteAddress, localAddress, serverNodeEngine, this);
        }

        public void start() throws IOException {
        }

        void handleClientMessage(final ClientMessage clientMessage) {
            this.executor.executeIncoming(new Runnable(){

                @Override
                public void run() {
                    MockedClientConnection.this.lastReadTime = System.currentTimeMillis();
                    MockedClientConnection.this.getConnectionManager().handleClientMessage(clientMessage, (Connection)MockedClientConnection.this);
                }

                public String toString() {
                    return "Runnable message " + clientMessage + ", " + (Object)((Object)MockedClientConnection.this);
                }
            });
        }

        public boolean write(final OutboundFrame frame) {
            Node node = this.serverNodeEngine.getNode();
            if (node.getState() == NodeState.SHUT_DOWN) {
                return false;
            }
            this.executor.executeOutgoing(new Runnable(){

                public String toString() {
                    return "Runnable message " + frame + ", " + (Object)((Object)MockedClientConnection.this);
                }

                @Override
                public void run() {
                    ClientMessage newPacket = MockedClientConnection.this.readFromPacket((ClientMessage)frame);
                    MockedClientConnection.this.lastWriteTime = System.currentTimeMillis();
                    MockedClientConnection.this.serverSideConnection.handleClientMessage(newPacket);
                }
            });
            return true;
        }

        private ClientMessage readFromPacket(ClientMessage packet) {
            return ClientMessage.createForDecode((ClientProtocolBuffer)packet.buffer(), (int)0);
        }

        public long lastReadTimeMillis() {
            return this.lastReadTime;
        }

        public long lastWriteTimeMillis() {
            return this.lastWriteTime;
        }

        public InetAddress getInetAddress() {
            try {
                return this.remoteAddress.getInetAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public InetSocketAddress getRemoteSocketAddress() {
            try {
                return this.remoteAddress.getInetSocketAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getPort() {
            return this.remoteAddress.getPort();
        }

        public InetSocketAddress getLocalSocketAddress() {
            try {
                return this.localAddress.getInetSocketAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void innerClose() throws IOException {
            this.executor.executeOutgoing(new Runnable(){

                @Override
                public void run() {
                    MockedClientConnection.this.serverSideConnection.close(null, null);
                }

                public String toString() {
                    return "Client Closed EOF. " + (Object)((Object)MockedClientConnection.this);
                }
            });
            this.executor.shutdownIncoming();
        }

        void onServerClose(final String reason) {
            this.executor.executeIncoming(new Runnable(){

                public String toString() {
                    return "Server Closed EOF. " + (Object)((Object)MockedClientConnection.this);
                }

                @Override
                public void run() {
                    MockedClientConnection.this.close(reason, new TargetDisconnectedException("Mocked Remote socket closed"));
                }
            });
            this.executor.shutdownOutgoing();
        }

        public String toString() {
            return "MockedClientConnection{, localAddress=" + this.localAddress + ", super=" + super.toString() + '}';
        }
    }

    class MockClientConnectionManager
    extends ClientConnectionManagerImpl {
        private final String host;
        private final AtomicInteger ports;
        private final HazelcastClientInstanceImpl client;
        private final ConcurrentHashMap<Address, TwoWayBlockableExecutor.LockPair> addressBlockMap;

        MockClientConnectionManager(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator, String host, AtomicInteger ports) {
            super(client, addressTranslator);
            this.addressBlockMap = new ConcurrentHashMap();
            this.client = client;
            this.host = host;
            this.ports = ports;
        }

        protected void initIOThreads(HazelcastClientInstanceImpl client) {
        }

        protected void startIOThreads() {
        }

        protected void shutdownIOThreads() {
        }

        protected ClientConnection createSocketConnection(Address address) throws IOException {
            if (!this.alive) {
                throw new HazelcastException("ConnectionManager is not active!!!");
            }
            try {
                HazelcastInstance instance = TestClientRegistry.this.nodeRegistry.getInstance(address);
                if (instance == null) {
                    throw new IOException("Can not connected to " + address + ": instance does not exist");
                }
                Node node = TestUtil.getNode((HazelcastInstance)instance);
                Address localAddress = new Address(this.host, this.ports.incrementAndGet());
                TwoWayBlockableExecutor.LockPair lockPair = (TwoWayBlockableExecutor.LockPair)ConcurrencyUtil.getOrPutIfAbsent(this.addressBlockMap, (Object)address, (ConstructorFunction)new ConstructorFunction<Address, TwoWayBlockableExecutor.LockPair>(){

                    public TwoWayBlockableExecutor.LockPair createNew(Address arg) {
                        return new TwoWayBlockableExecutor.LockPair(new ReentrantReadWriteLock(), new ReentrantReadWriteLock());
                    }
                });
                MockedClientConnection connection = new MockedClientConnection(this.client, this.connectionIdGen.incrementAndGet(), node.nodeEngine, address, localAddress, lockPair);
                LOGGER.info("Created connection to endpoint: " + address + ", connection: " + (Object)((Object)connection));
                return connection;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
            }
        }

        void blockFrom(Address address) {
            LOGGER.info("Blocked messages from " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.addressBlockMap.get(address);
            lockPair.blockIncoming();
        }

        void unblockFrom(Address address) {
            LOGGER.info("Unblocked messages from " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.addressBlockMap.get(address);
            lockPair.unblockIncoming();
        }

        void blockTo(Address address) {
            LOGGER.info("Blocked messages to " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.addressBlockMap.get(address);
            lockPair.blockOutgoing();
        }

        void unblockTo(Address address) {
            LOGGER.info("Unblocked messages to " + address);
            TwoWayBlockableExecutor.LockPair lockPair = this.addressBlockMap.get(address);
            lockPair.unblockOutgoing();
        }
    }

    private class MockClientConnectionManagerFactory
    implements ClientConnectionManagerFactory {
        private final String host;
        private final AtomicInteger ports;

        MockClientConnectionManagerFactory(String host, AtomicInteger ports) {
            this.host = host;
            this.ports = ports;
        }

        public ClientConnectionManager createConnectionManager(ClientConfig config, HazelcastClientInstanceImpl client, DiscoveryService discoveryService) {
            Object addressTranslator;
            ClientAwsConfig awsConfig = config.getNetworkConfig().getAwsConfig();
            if (awsConfig != null && awsConfig.isEnabled()) {
                try {
                    addressTranslator = new AwsAddressTranslator(awsConfig, client.getLoggingService());
                }
                catch (NoClassDefFoundError e) {
                    LOGGER.log(Level.WARNING, "hazelcast-aws.jar might be missing!");
                    throw e;
                }
            } else {
                addressTranslator = discoveryService != null ? new DiscoveryAddressTranslator(discoveryService, client.getProperties().getBoolean(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED)) : new DefaultAddressTranslator();
            }
            return new MockClientConnectionManager(client, (AddressTranslator)addressTranslator, this.host, this.ports);
        }
    }
}

