/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test.bounce;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.bounce.BounceMemberRule;
import com.hazelcast.test.bounce.BounceTestConfiguration;
import com.hazelcast.test.bounce.DriverFactory;
import java.net.InetSocketAddress;

public class ClientDriverFactory
implements DriverFactory {
    public HazelcastInstance[] createTestDrivers(BounceMemberRule rule) {
        BounceTestConfiguration testConfiguration = rule.getBounceTestConfig();
        switch (testConfiguration.getDriverType()) {
            case CLIENT: {
                HazelcastInstance[] drivers = new HazelcastInstance[testConfiguration.getDriverCount()];
                for (int i = 0; i < drivers.length; ++i) {
                    drivers[i] = ((TestHazelcastFactory)rule.getFactory()).newHazelcastClient(this.getClientConfig(rule.getSteadyMember()));
                }
                HazelcastTestSupport.waitAllForSafeState((HazelcastInstance[])drivers);
                return drivers;
            }
        }
        throw new AssertionError((Object)("ClientDriverFactory cannot create test drivers for " + testConfiguration.getDriverType()));
    }

    protected ClientConfig getClientConfig(HazelcastInstance member) {
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), "false");
        config.getNetworkConfig().setSmartRouting(false);
        InetSocketAddress socketAddress = member.getCluster().getLocalMember().getSocketAddress();
        config.getNetworkConfig().addAddress(new String[]{socketAddress.getHostName() + ":" + socketAddress.getPort()});
        return config;
    }
}

