/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.topic;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AbstractHazelcastClassRunner;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.topic.impl.reliable.TopicOverloadAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReliableTopicOverloadTest
extends TopicOverloadAbstractTest {
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setupCluster() {
        Config config = new Config();
        config.addRingBufferConfig(new RingbufferConfig("when*").setCapacity(100).setTimeToLiveSeconds(Integer.MAX_VALUE));
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addReliableTopicConfig(new ClientReliableTopicConfig("whenError_*").setTopicOverloadPolicy(TopicOverloadPolicy.ERROR));
        clientConfig.addReliableTopicConfig(new ClientReliableTopicConfig("whenDiscardOldest_*").setTopicOverloadPolicy(TopicOverloadPolicy.DISCARD_OLDEST));
        clientConfig.addReliableTopicConfig(new ClientReliableTopicConfig("whenDiscardNewest_*").setTopicOverloadPolicy(TopicOverloadPolicy.DISCARD_NEWEST));
        clientConfig.addReliableTopicConfig(new ClientReliableTopicConfig("whenBlock_*").setTopicOverloadPolicy(TopicOverloadPolicy.BLOCK));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.serializationService = ((HazelcastClientProxy)client).getSerializationService();
        String topicName = AbstractHazelcastClassRunner.getTestMethodName();
        this.topic = client.getReliableTopic(topicName);
        this.ringbuffer = ((ClientReliableTopicProxy)this.topic).getRingbuffer();
    }

    @After
    public void terminate() {
        this.hazelcastFactory.terminateAll();
    }
}

