/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.topic;

import com.hazelcast.client.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.impl.reliable.ReliableMessageListenerMock;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReliableTopicTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setup() {
        Config config = new Config();
        this.hazelcastFactory.newHazelcastInstance(config);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testCreation() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        ClientReliableTopicTest.assertInstanceOf(ClientReliableTopicProxy.class, (Object)topic);
    }

    @Test(expected=NullPointerException.class)
    public void addMessageListener_whenNull() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        topic.addMessageListener(null);
    }

    @Test
    public void addMessageListener() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        String id = topic.addMessageListener((MessageListener)new ReliableMessageListenerMock());
        Assert.assertNotNull((Object)id);
    }

    @Test(expected=NullPointerException.class)
    public void removeMessageListener_whenNull() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        topic.removeMessageListener(null);
    }

    @Test
    public void removeMessageListener_whenExisting() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        String id = topic.addMessageListener((MessageListener)listener);
        boolean removed = topic.removeMessageListener(id);
        Assert.assertTrue((boolean)removed);
        topic.publish((Object)"1");
        ClientReliableTopicTest.assertTrueDelayed5sec((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)listener.objects.size());
            }
        });
    }

    @Test
    public void removeMessageListener_whenNonExisting() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        boolean result = topic.removeMessageListener(UUID.randomUUID().toString());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void removeMessageListener_whenAlreadyRemoved() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        String id = topic.addMessageListener((MessageListener)listener);
        topic.removeMessageListener(id);
        boolean result = topic.removeMessageListener(id);
        Assert.assertFalse((boolean)result);
        topic.publish((Object)"1");
        ClientReliableTopicTest.assertTrueDelayed5sec((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)listener.objects.size());
            }
        });
    }

    @Test
    public void publishSingle() throws InterruptedException {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        topic.addMessageListener((MessageListener)listener);
        String msg = "foobar";
        topic.publish((Object)"foobar");
        ClientReliableTopicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastTestSupport.assertContains((Collection)listener.objects, (Object)"foobar");
            }
        });
    }

    @Test
    public void publishNull() throws InterruptedException {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        topic.addMessageListener((MessageListener)listener);
        topic.publish(null);
        ClientReliableTopicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                HazelcastTestSupport.assertContains((Collection)listener.objects, null);
            }
        });
    }

    @Test
    public void publishMultiple() throws InterruptedException {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        topic.addMessageListener((MessageListener)listener);
        final ArrayList<String> items = new ArrayList<String>();
        for (int k = 0; k < 5; ++k) {
            items.add("" + k);
        }
        for (String item : items) {
            topic.publish((Object)item);
        }
        ClientReliableTopicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)items, Arrays.asList(listener.objects.toArray()));
            }
        });
    }

    @Test
    public void testMessageFieldSetCorrectly() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        topic.addMessageListener((MessageListener)listener);
        final long beforePublishTime = Clock.currentTimeMillis();
        final String messageStr = ClientReliableTopicTest.randomString();
        topic.publish((Object)messageStr);
        final long afterPublishTime = Clock.currentTimeMillis();
        ClientReliableTopicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)listener.messages.size());
                Message message = (Message)listener.messages.get(0);
                Assert.assertEquals((Object)messageStr, (Object)message.getMessageObject());
                Assert.assertEquals(null, (Object)message.getPublishingMember());
                long actualPublishTime = message.getPublishTime();
                Assert.assertTrue((actualPublishTime >= beforePublishTime ? 1 : 0) != 0);
                Assert.assertTrue((actualPublishTime <= afterPublishTime ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testAlwaysStartAfterTail() {
        final ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        topic.publish((Object)"1");
        topic.publish((Object)"2");
        topic.publish((Object)"3");
        ClientReliableTopicTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                HazelcastTestSupport.sleepSeconds((int)5);
                topic.publish((Object)"4");
                topic.publish((Object)"5");
                topic.publish((Object)"6");
            }
        });
        final ReliableMessageListenerMock listener = new ReliableMessageListenerMock();
        topic.addMessageListener((MessageListener)listener);
        ClientReliableTopicTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals(Arrays.asList("4", "5", "6"), Arrays.asList(listener.objects.toArray()));
            }
        });
    }

    @Test
    public void testListener() throws InterruptedException {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        int messageCount = 10;
        final CountDownLatch latch = new CountDownLatch(messageCount);
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        };
        topic.addMessageListener(listener);
        for (int i = 0; i < messageCount; ++i) {
            topic.publish((Object)i);
        }
        Assert.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void testRemoveListener() {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
            }
        };
        String id = topic.addMessageListener(listener);
        Assert.assertTrue((boolean)topic.removeMessageListener(id));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetLocalTopicStats() throws Exception {
        ITopic topic = this.client.getReliableTopic(ClientReliableTopicTest.randomString());
        topic.getLocalTopicStats();
    }
}

