/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.topic;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class Issue9766Test {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    static final String topicName = "foo";

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void serverRestartWhenReliableTopicListenerRegistered() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance hazelcastClient = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance hazelcastClient2 = this.hazelcastFactory.newHazelcastClient();
        ITopic topic = hazelcastClient.getReliableTopic(topicName);
        ITopic topic2 = hazelcastClient2.getReliableTopic(topicName);
        final CountDownLatch listenerLatch = new CountDownLatch(1);
        topic.addMessageListener((MessageListener)new MessageListener<Integer>(){

            public void onMessage(Message<Integer> message) {
                listenerLatch.countDown();
            }
        });
        server.getLifecycleService().terminate();
        this.hazelcastFactory.newHazelcastInstance();
        topic2.publish((Object)5);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listenerLatch);
    }
}

