/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTransactionTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test(expected=TransactionException.class)
    public void testTxnRollback_WithExecuteTask_throwsTransactionException() {
        this.client.executeTransaction((TransactionalTask)new TransactionalTask<Object>(){

            public Object execute(TransactionalTaskContext context) throws TransactionException {
                throw new TransactionException();
            }
        });
    }

    @Test(expected=TransactionException.class)
    public void testTxnRollback_WithExecuteTask_throwsTransactionExceptionAsCause() {
        this.client.executeTransaction((TransactionalTask)new TransactionalTask<Object>(){

            public Object execute(TransactionalTaskContext context) throws TransactionException {
                throw new RuntimeException(new TransactionException());
            }
        });
    }

    @Test(expected=RuntimeException.class)
    public void testTxnRollback_WithExecuteTask_throwsRuntimeException() {
        this.client.executeTransaction((TransactionalTask)new TransactionalTask<Object>(){

            public Object execute(TransactionalTaskContext context) throws TransactionException {
                throw new RuntimeException();
            }
        });
    }

    @Test(expected=TransactionException.class)
    public void testTxnRollback_WithExecuteTask_throwsError() {
        this.client.executeTransaction((TransactionalTask)new TransactionalTask<Object>(){

            public Object execute(TransactionalTaskContext context) throws TransactionException {
                throw new Error();
            }
        });
    }
}

