/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationparker.impl.OperationParkerImpl;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnDisconnectionTest {
    private static final String BOUNDED_QUEUE_PREFIX = "bounded-queue-*";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private OperationParkerImpl waitNotifyService;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        Config config = new Config();
        config.getQueueConfig(BOUNDED_QUEUE_PREFIX).setMaxSize(1);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(config);
        NodeEngineImpl nodeEngine = HazelcastTestSupport.getNode((HazelcastInstance)instance).nodeEngine;
        this.waitNotifyService = (OperationParkerImpl)nodeEngine.getOperationParker();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testQueueTake() {
        this.testQueue(new Callable(){

            public Object call() throws InterruptedException {
                TransactionContext context = ClientTxnDisconnectionTest.this.client.newTransactionContext();
                context.beginTransaction();
                TransactionalQueue queue = context.getQueue(HazelcastTestSupport.randomString());
                return queue.take();
            }
        });
    }

    @Test
    public void testQueuePoll() {
        this.testQueue(new Callable(){

            public Object call() throws InterruptedException {
                TransactionContext context = ClientTxnDisconnectionTest.this.client.newTransactionContext();
                context.beginTransaction();
                TransactionalQueue queue = context.getQueue(HazelcastTestSupport.randomString());
                return queue.poll(20L, TimeUnit.SECONDS);
            }
        });
    }

    @Test
    public void testQueueOffer() {
        this.testQueue(new Callable(){

            public Object call() throws InterruptedException {
                String name = ClientTxnDisconnectionTest.BOUNDED_QUEUE_PREFIX + HazelcastTestSupport.randomString();
                ClientTxnDisconnectionTest.this.client.getQueue(name).offer((Object)HazelcastTestSupport.randomString());
                TransactionContext context = ClientTxnDisconnectionTest.this.client.newTransactionContext();
                context.beginTransaction();
                TransactionalQueue queue = context.getQueue(name);
                return queue.offer((Object)HazelcastTestSupport.randomString(), 20L, TimeUnit.SECONDS);
            }
        });
    }

    private void testQueue(Callable task) {
        HazelcastTestSupport.spawn((Callable)task);
        this.assertValidWaitingOperationCount(1);
        this.client.shutdown();
        this.assertValidWaitingOperationCount(0);
    }

    private void assertValidWaitingOperationCount(final int count) {
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)count, (long)ClientTxnDisconnectionTest.this.waitNotifyService.getTotalValidWaitingOperationCount());
            }
        });
    }
}

