/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnListTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testAddRemove() throws Exception {
        String listName = HazelcastTestSupport.randomString();
        IList l = this.client.getList(listName);
        l.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalList list = context.getList(listName);
        Assert.assertTrue((boolean)list.add((Object)"item2"));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertFalse((boolean)list.remove((Object)"item3"));
        Assert.assertTrue((boolean)list.remove((Object)"item1"));
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)l.size());
    }

    @Test
    public void testAddAndRoleBack() throws Exception {
        String listName = HazelcastTestSupport.randomString();
        IList l = this.client.getList(listName);
        l.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalList list = context.getList(listName);
        list.add((Object)"item2");
        context.rollbackTransaction();
        Assert.assertEquals((long)1L, (long)l.size());
    }
}

