/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SampleObjects;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnMapTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testUnlockAfterRollback() {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap map = context.getMap(mapName);
        map.put((Object)"key", (Object)"value");
        context.rollbackTransaction();
        Assert.assertFalse((boolean)this.client.getMap(mapName).isLocked((Object)"key"));
    }

    @Test
    public void testDeadLockFromClientInstance() throws InterruptedException {
        final String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (running.get()) {
                    ClientTxnMapTest.this.client.getMap(mapName).get((Object)"key");
                }
            }
        };
        t.start();
        CBAuthorisation cb = new CBAuthorisation();
        cb.setAmount(15000);
        try {
            TransactionContext context = this.client.newTransactionContext();
            context.beginTransaction();
            TransactionalMap mapTransaction = context.getMap(mapName);
            mapTransaction.put((Object)"key", (Object)cb);
            cb.setAmount(12000);
            mapTransaction.set((Object)"key", (Object)cb);
            cb.setAmount(10000);
            mapTransaction.set((Object)"key", (Object)cb);
            cb.setAmount(900);
            mapTransaction.set((Object)"key", (Object)cb);
            cb.setAmount(800);
            mapTransaction.set((Object)"key", (Object)cb);
            cb.setAmount(700);
            mapTransaction.set((Object)"key", (Object)cb);
            context.commitTransaction();
        }
        catch (TransactionException e) {
            e.printStackTrace();
            Assert.fail();
        }
        running.set(false);
        t.join();
    }

    @Test
    public void testTxnMapPut() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "Value";
        IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txnMap = context.getMap(mapName);
        txnMap.put((Object)"key", (Object)"Value");
        context.commitTransaction();
        Assert.assertEquals((Object)"Value", (Object)map.get((Object)"key"));
    }

    @Test
    public void testTxnMapPut_BeforeCommit() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "Value";
        IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txnMap = context.getMap(mapName);
        Assert.assertNull((Object)txnMap.put((Object)"key", (Object)"Value"));
        context.commitTransaction();
    }

    @Test
    public void testTxnMapGet_BeforeCommit() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "Value";
        IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txnMap = context.getMap(mapName);
        txnMap.put((Object)"key", (Object)"Value");
        Assert.assertEquals((Object)"Value", (Object)txnMap.get((Object)"key"));
        Assert.assertNull((Object)map.get((Object)"key"));
        context.commitTransaction();
    }

    @Test
    public void testPutWithTTL() {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "Value";
        final IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txnMap = context.getMap(mapName);
        txnMap.put((Object)"key", (Object)"Value", 10L, TimeUnit.SECONDS);
        Assert.assertNull((Object)map.get((Object)"key"));
        context.commitTransaction();
        Assert.assertEquals((Object)"Value", (Object)map.get((Object)"key"));
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)map.get((Object)"key"));
            }
        });
    }

    @Test
    public void testGetForUpdate() throws TransactionException {
        final String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        int initialValue = 111;
        int value = 888;
        final CountDownLatch getKeyForUpdateLatch = new CountDownLatch(1);
        final CountDownLatch afterTryPutResult = new CountDownLatch(1);
        final IMap map = this.client.getMap(mapName);
        map.put((Object)"key", (Object)111);
        final AtomicBoolean tryPutResult = new AtomicBoolean(true);
        Runnable incrementor = new Runnable(){

            @Override
            public void run() {
                try {
                    getKeyForUpdateLatch.await(30L, TimeUnit.SECONDS);
                    boolean result = map.tryPut((Object)"key", (Object)888, 0L, TimeUnit.SECONDS);
                    tryPutResult.set(result);
                    afterTryPutResult.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        new Thread(incrementor).start();
        this.client.executeTransaction((TransactionalTask)new TransactionalTask<Boolean>(){

            public Boolean execute(TransactionalTaskContext context) throws TransactionException {
                try {
                    TransactionalMap txMap = context.getMap(mapName);
                    txMap.getForUpdate((Object)"key");
                    getKeyForUpdateLatch.countDown();
                    afterTryPutResult.await(30L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        });
        Assert.assertFalse((boolean)tryPutResult.get());
    }

    @Test
    public void testKeySetValues() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"value1");
        map.put((Object)"key2", (Object)"value1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        Assert.assertNull((Object)txMap.put((Object)"key3", (Object)"value2"));
        Assert.assertEquals((long)3L, (long)txMap.size());
        Assert.assertEquals((long)3L, (long)txMap.keySet().size());
        Assert.assertEquals((long)3L, (long)txMap.values().size());
        context.commitTransaction();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)3L, (long)map.keySet().size());
        Assert.assertEquals((long)3L, (long)map.values().size());
    }

    @Test
    public void testKeysetAndValuesWithPredicates() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        SampleObjects.Employee emp1 = new SampleObjects.Employee("abc-123-xvz", 34, true, 10.0);
        SampleObjects.Employee emp2 = new SampleObjects.Employee("abc-123-xvz", 20, true, 10.0);
        map.put((Object)emp1, (Object)emp1);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        Assert.assertNull((Object)txMap.put((Object)emp2, (Object)emp2));
        Assert.assertEquals((long)2L, (long)txMap.size());
        Assert.assertEquals((long)2L, (long)txMap.keySet().size());
        Assert.assertEquals((long)0L, (long)txMap.keySet((Predicate)new SqlPredicate("age = 10")).size());
        Assert.assertEquals((long)0L, (long)txMap.values((Predicate)new SqlPredicate("age = 10")).size());
        Assert.assertEquals((long)2L, (long)txMap.keySet((Predicate)new SqlPredicate("age >= 10")).size());
        Assert.assertEquals((long)2L, (long)txMap.values((Predicate)new SqlPredicate("age >= 10")).size());
        context.commitTransaction();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)2L, (long)map.values().size());
    }

    @Test
    public void testDuplicateValuesWithPredicates() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        SampleObjects.Employee emp1 = new SampleObjects.Employee("employee1", 10, true, 10.0);
        map.put((Object)"employee1", (Object)emp1);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        Assert.assertNull((Object)txMap.put((Object)"employee1_repeated", (Object)emp1));
        Assert.assertEquals((long)2L, (long)txMap.size());
        Assert.assertEquals((long)2L, (long)txMap.keySet((Predicate)new SqlPredicate("age = 10")).size());
        Assert.assertEquals((long)2L, (long)txMap.values((Predicate)new SqlPredicate("age = 10")).size());
        context.commitTransaction();
        Assert.assertEquals((long)2L, (long)map.keySet((Predicate)new SqlPredicate("age = 10")).size());
        Assert.assertEquals((long)2L, (long)map.values((Predicate)new SqlPredicate("age = 10")).size());
    }

    @Test
    public void testPutAndRoleBack() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap mapTxn = context.getMap(mapName);
        mapTxn.put((Object)"key", (Object)"value");
        context.rollbackTransaction();
        Assert.assertNull((Object)map.get((Object)"key"));
    }

    @Test
    public void testTnxMapContainsKey() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"value1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.put((Object)"key2", (Object)"value2");
        Assert.assertTrue((boolean)txMap.containsKey((Object)"key1"));
        Assert.assertTrue((boolean)txMap.containsKey((Object)"key2"));
        Assert.assertFalse((boolean)txMap.containsKey((Object)"key3"));
        context.commitTransaction();
    }

    @Test
    public void testTnxMapIsEmpty() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        Assert.assertTrue((boolean)txMap.isEmpty());
        context.commitTransaction();
    }

    @Test
    public void testTnxMapPutIfAbsent() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String keyValue1 = "keyValue1";
        String keyValue2 = "keyValue2";
        map.put((Object)"keyValue1", (Object)"keyValue1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.putIfAbsent((Object)"keyValue1", (Object)"NOT_THIS");
        txMap.putIfAbsent((Object)"keyValue2", (Object)"keyValue2");
        context.commitTransaction();
        Assert.assertEquals((Object)"keyValue1", (Object)map.get((Object)"keyValue1"));
        Assert.assertEquals((Object)"keyValue2", (Object)map.get((Object)"keyValue2"));
    }

    @Test
    public void testTnxMapReplace() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        IMap map = this.client.getMap(mapName);
        String key1 = "key1";
        String key2 = "key2";
        String replaceValue = "replaceValue";
        map.put((Object)"key1", (Object)"OLD_VALUE");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.replace((Object)"key1", (Object)"replaceValue");
        txMap.replace((Object)"key2", (Object)"NOT_POSSIBLE");
        context.commitTransaction();
        Assert.assertEquals((Object)"replaceValue", (Object)map.get((Object)"key1"));
        Assert.assertNull((Object)map.get((Object)"key2"));
    }

    @Test
    public void testTnxMapReplaceKeyValue() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key1 = "key1";
        String oldValue1 = "old1";
        String newValue1 = "new1";
        String key2 = "key2";
        String oldValue2 = "old2";
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"old1");
        map.put((Object)"key2", (Object)"old2");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.replace((Object)"key1", (Object)"old1", (Object)"new1");
        txMap.replace((Object)"key2", (Object)"NOT_OLD_VALUE", (Object)"NEW_VALUE_CANT_BE_THIS");
        context.commitTransaction();
        Assert.assertEquals((Object)"new1", (Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)"old2", (Object)map.get((Object)"key2"));
    }

    @Test
    public void testTnxMapRemove() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key1";
        String value = "old1";
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"old1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.remove((Object)"key1");
        context.commitTransaction();
        Assert.assertNull((Object)map.get((Object)"key1"));
    }

    @Test
    public void testTnxMapRemoveKeyValue() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key1 = "key1";
        String oldValue1 = "old1";
        String key2 = "key2";
        String oldValue2 = "old2";
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"old1");
        map.put((Object)"key2", (Object)"old2");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.remove((Object)"key1", (Object)"old1");
        txMap.remove((Object)"key2", (Object)"NO_REMOVE_AS_NOT_VALUE");
        context.commitTransaction();
        Assert.assertNull((Object)map.get((Object)"key1"));
        Assert.assertEquals((Object)"old2", (Object)map.get((Object)"key2"));
    }

    @Test
    public void testTnxMapDelete() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key1";
        String value = "old1";
        IMap map = this.client.getMap(mapName);
        map.put((Object)"key1", (Object)"old1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.delete((Object)"key1");
        context.commitTransaction();
        Assert.assertNull((Object)map.get((Object)"key1"));
    }

    @Test(expected=NullPointerException.class)
    public void testKeySetPredicateNull() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.keySet(null);
    }

    @Test(expected=NullPointerException.class)
    public void testKeyValuesPredicateNull() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap txMap = context.getMap(mapName);
        txMap.values(null);
    }

    @Test
    public void testPutDoesNotDeserializeOnServerSide() {
        String name = HazelcastTestSupport.randomString();
        this.client.getMap(name).put((Object)5, (Object)new DeserializeOnceObject(5));
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalMap map = context.getMap(name);
        map.put((Object)5, (Object)new DeserializeOnceObject(6));
        context.commitTransaction();
    }

    private static class DeserializeOnceObject
    implements DataSerializable {
        private int amount;
        private static AtomicBoolean readCalled = new AtomicBoolean(false);

        public DeserializeOnceObject() {
        }

        public DeserializeOnceObject(int amount) {
            this.amount = amount;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.amount);
        }

        public void readData(ObjectDataInput in) throws IOException {
            if (!readCalled.compareAndSet(false, true)) {
                throw new AssertionError((Object)"Read called more than once!!!");
            }
            this.amount = in.readInt();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeserializeOnceObject)) {
                return false;
            }
            DeserializeOnceObject that = (DeserializeOnceObject)o;
            return this.amount == that.amount;
        }

        public int hashCode() {
            return this.amount;
        }
    }

    public static class CBAuthorisation
    implements Serializable {
        private int amount;

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

