/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnMultiMapTest {
    private static final String multiMapBackedByList = "BackedByList*";
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testRemove() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String val = "value";
        MultiMap multiMap = this.client.getMultiMap(mapName);
        multiMap.put((Object)"key", (Object)"value");
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap txnMultiMap = tx.getMultiMap(mapName);
        txnMultiMap.remove((Object)"key", (Object)"value");
        tx.commitTransaction();
        Assert.assertTrue((boolean)this.client.getMultiMap(mapName).get((Object)"key").isEmpty());
    }

    @Test
    public void testRemoveAll() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        MultiMap multiMap = this.client.getMultiMap(mapName);
        for (int i = 0; i < 10; ++i) {
            multiMap.put((Object)"key", (Object)i);
        }
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap txnMultiMap = tx.getMultiMap(mapName);
        txnMultiMap.remove((Object)"key");
        tx.commitTransaction();
        Assert.assertTrue((boolean)multiMap.get((Object)"key").isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcrruentTxnPut() throws Exception {
        final String mapName = HazelcastTestSupport.randomString();
        final MultiMap multiMap = this.client.getMultiMap(mapName);
        int threads = 10;
        ExecutorService ex = Executors.newFixedThreadPool(10);
        final CountDownLatch latch = new CountDownLatch(10);
        final AtomicReference<Object> error = new AtomicReference<Object>(null);
        int i = 0;
        while (i < 10) {
            final int key = i++;
            ex.execute(new Runnable(){

                @Override
                public void run() {
                    multiMap.put((Object)key, (Object)"value");
                    TransactionContext context = ClientTxnMultiMapTest.this.client.newTransactionContext();
                    try {
                        context.beginTransaction();
                        TransactionalMultiMap txnMultiMap = context.getMultiMap(mapName);
                        txnMultiMap.put((Object)key, (Object)"value");
                        txnMultiMap.put((Object)key, (Object)"value1");
                        txnMultiMap.put((Object)key, (Object)"value2");
                        Assert.assertEquals((long)3L, (long)txnMultiMap.get((Object)key).size());
                        context.commitTransaction();
                        Assert.assertEquals((long)3L, (long)multiMap.get((Object)key).size());
                    }
                    catch (Exception e) {
                        error.compareAndSet(null, e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await(1L, TimeUnit.MINUTES);
            Assert.assertNull(error.get());
        }
        finally {
            ex.shutdownNow();
        }
    }

    @Test
    public void testPutAndRoleBack() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        MultiMap multiMap = this.client.getMultiMap(mapName);
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap mulitMapTxn = tx.getMultiMap(mapName);
        mulitMapTxn.put((Object)"key", (Object)"value");
        mulitMapTxn.put((Object)"key", (Object)"value");
        tx.rollbackTransaction();
        Assert.assertEquals((long)0L, (long)multiMap.get((Object)"key").size());
    }

    @Test
    public void testSize() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        MultiMap multiMap = this.client.getMultiMap(mapName);
        multiMap.put((Object)"key", (Object)"value");
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap mulitMapTxn = tx.getMultiMap(mapName);
        mulitMapTxn.put((Object)"key", (Object)"newValue");
        mulitMapTxn.put((Object)"newKey", (Object)"value");
        Assert.assertEquals((long)3L, (long)mulitMapTxn.size());
        tx.commitTransaction();
    }

    @Test
    public void testCount() throws Exception {
        String mapName = HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        MultiMap multiMap = this.client.getMultiMap(mapName);
        multiMap.put((Object)"key", (Object)"value");
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap mulitMapTxn = tx.getMultiMap(mapName);
        mulitMapTxn.put((Object)"key", (Object)"newValue");
        Assert.assertEquals((long)2L, (long)mulitMapTxn.valueCount((Object)"key"));
        tx.commitTransaction();
    }

    @Test
    public void testGet_whenBackedWithList() throws Exception {
        String mapName = multiMapBackedByList + HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        MultiMap multiMap = this.server.getMultiMap(mapName);
        multiMap.put((Object)"key", (Object)"value");
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap mulitMapTxn = tx.getMultiMap(mapName);
        Collection c = mulitMapTxn.get((Object)"key");
        Assert.assertFalse((boolean)c.isEmpty());
        tx.commitTransaction();
    }

    @Test
    public void testRemove_whenBackedWithList() throws Exception {
        String mapName = multiMapBackedByList + HazelcastTestSupport.randomString();
        String key = "key";
        String value = "value";
        MultiMap multiMap = this.server.getMultiMap(mapName);
        multiMap.put((Object)"key", (Object)"value");
        TransactionContext tx = this.client.newTransactionContext();
        tx.beginTransaction();
        TransactionalMultiMap mulitMapTxn = tx.getMultiMap(mapName);
        Collection c = mulitMapTxn.remove((Object)"key");
        Assert.assertFalse((boolean)c.isEmpty());
        tx.commitTransaction();
    }
}

