/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISet;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnSetTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testAdd_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        Assert.assertTrue((boolean)txnSet.add((Object)"item1"));
        Assert.assertEquals((long)1L, (long)txnSet.size());
        context.commitTransaction();
    }

    @Test
    public void testSetSizeAfterAdd_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        txnSet.add((Object)"item1");
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testRemove_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        set.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        Assert.assertTrue((boolean)txnSet.remove((Object)"item1"));
        Assert.assertFalse((boolean)txnSet.remove((Object)"NOT_THERE"));
        context.commitTransaction();
    }

    @Test
    public void testSetSizeAfterRemove_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        set.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        txnSet.remove((Object)"item1");
        context.commitTransaction();
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void testAddDuplicateElement_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        Assert.assertTrue((boolean)txnSet.add((Object)"item1"));
        Assert.assertFalse((boolean)txnSet.add((Object)"item1"));
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.client.getSet(setName).size());
    }

    @Test
    public void testAddExistingElement_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        set.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        Assert.assertFalse((boolean)txnSet.add((Object)"item1"));
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testSetSizeAfterAddingDuplicateElement_withinTxn() throws Exception {
        String element = "item1";
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        set.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet txnSet = context.getSet(setName);
        txnSet.add((Object)"item1");
        context.commitTransaction();
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testAddRollBack() throws Exception {
        String setName = HazelcastTestSupport.randomString();
        ISet set = this.client.getSet(setName);
        set.add((Object)"item1");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalSet setTxn = context.getSet(setName);
        setTxn.add((Object)"item2");
        context.rollbackTransaction();
        Assert.assertEquals((long)1L, (long)set.size());
    }
}

