/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.atomikos.datasource.xa.XID;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientXAStressTest
extends HazelcastTestSupport {
    private HazelcastInstance instance;
    private HazelcastInstance secondInstance;
    private HazelcastInstance client;
    private HazelcastInstance secondClient;
    private HazelcastXAResource xaResource;
    private HazelcastXAResource secondXaResource;
    private HazelcastXAResource instanceXaResource;

    private static Xid createXid() throws InterruptedException {
        return new XID(ClientXAStressTest.randomString(), "test");
    }

    @Before
    public void setUp() throws Exception {
        this.instance = Hazelcast.newHazelcastInstance();
        this.secondInstance = Hazelcast.newHazelcastInstance();
        this.instanceXaResource = this.instance.getXAResource();
        this.client = HazelcastClient.newHazelcastClient();
        this.secondClient = HazelcastClient.newHazelcastClient();
        this.xaResource = this.client.getXAResource();
        this.secondXaResource = this.secondClient.getXAResource();
    }

    @After
    public void tearDown() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testCommitConcurrently() throws InterruptedException, XAException {
        int count = 10000;
        String name = ClientXAStressTest.randomString();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        ExecutorService executorServiceForCommit = Executors.newFixedThreadPool(5);
        for (int i = 0; i < count; ++i) {
            XATransactionRunnable runnable = new XATransactionRunnable(this.xaResource, name, executorServiceForCommit, i);
            executorService.execute(runnable);
        }
        IMap map = this.client.getMap(name);
        ClientXAStressTest.assertSizeEventually((int)count, (Map)map);
        executorService.shutdown();
        executorServiceForCommit.shutdown();
    }

    static class XATransactionRunnable
    implements Runnable {
        HazelcastXAResource xaResource;
        String name;
        ExecutorService executorServiceForCommit;
        int i;

        public XATransactionRunnable(HazelcastXAResource xaResource, String name, ExecutorService executorServiceForCommit, int i) {
            this.xaResource = xaResource;
            this.name = name;
            this.executorServiceForCommit = executorServiceForCommit;
            this.i = i;
        }

        @Override
        public void run() {
            try {
                final Xid xid = ClientXAStressTest.createXid();
                this.xaResource.start(xid, 0);
                TransactionContext context = this.xaResource.getTransactionContext();
                TransactionalMap map = context.getMap(this.name);
                map.put((Object)this.i, (Object)this.i);
                this.xaResource.end(xid, 0x4000000);
                this.executorServiceForCommit.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            XATransactionRunnable.this.xaResource.commit(xid, true);
                        }
                        catch (XAException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

