/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.datamodel;

import com.higherfrequencytrading.chronicle.Chronicle;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.ExcerptMarshallable;
import com.higherfrequencytrading.chronicle.datamodel.ListWrapper;
import com.higherfrequencytrading.chronicle.datamodel.MapWrapper;
import com.higherfrequencytrading.chronicle.datamodel.ModelMode;
import com.higherfrequencytrading.chronicle.datamodel.ObservableList;
import com.higherfrequencytrading.chronicle.datamodel.ObservableMap;
import com.higherfrequencytrading.chronicle.datamodel.ObservableSet;
import com.higherfrequencytrading.chronicle.datamodel.SetWrapper;
import com.higherfrequencytrading.chronicle.datamodel.Wrapper;
import com.higherfrequencytrading.chronicle.tcp.InProcessChronicleSink;
import com.higherfrequencytrading.chronicle.tools.ChronicleTools;
import java.io.Closeable;
import java.io.Externalizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataStore
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(DataStore.class.getName());
    protected final Map<String, Wrapper> wrappers = new ConcurrentHashMap<String, Wrapper>();
    @NotNull
    private final Chronicle chronicle;
    @NotNull
    private final ModelMode mode;
    @NotNull
    protected Wrapper[] wrappersArray = new Wrapper[0];
    @Nullable
    private Excerpt excerpt = null;
    @Nullable
    private ExecutorService updater;
    private volatile boolean closed = false;

    public DataStore(@NotNull Chronicle chronicle, @NotNull ModelMode mode) {
        this.chronicle = chronicle;
        this.mode = mode;
        switch (mode) {
            case MASTER: {
                break;
            }
            case READ_ONLY: {
                final String name = chronicle.name();
                if (chronicle instanceof InProcessChronicleSink) {
                    this.updater = Executors.newSingleThreadExecutor(new ThreadFactory(){

                        @Override
                        @NotNull
                        public Thread newThread(@NotNull Runnable r) {
                            Thread t = new Thread(r, name + "data store updater");
                            t.setDaemon(true);
                            return t;
                        }
                    });
                    break;
                }
                this.updater = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode " + (Object)((Object)mode));
            }
        }
    }

    public <Model> void inject(@NotNull Model model) {
        try {
            for (Class<?> type = model.getClass(); type != null && type != Object.class && type != Enum.class; type = type.getSuperclass()) {
                for (Field field : type.getDeclaredFields()) {
                    this.injectField(model, field);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <Model> void injectField(Model model, @NotNull Field field) throws IllegalAccessException {
        if ((field.getModifiers() & 8) != 0 || (field.getModifiers() & 0x80) != 0) {
            return;
        }
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (fieldType.isInterface()) {
            if (fieldType == Map.class || fieldType == ObservableMap.class) {
                Class[] genericTypes = ChronicleTools.getGenericTypes(field.getGenericType(), 2);
                ConcurrentHashMap underlying = (ConcurrentHashMap)field.get(model);
                if (underlying == null) {
                    underlying = new ConcurrentHashMap();
                }
                MapWrapper map = new MapWrapper(this, field.getName(), genericTypes[0], genericTypes[1], underlying, 1024);
                Annotation[] annotations = field.getAnnotations();
                if (annotations != null) {
                    map.setAnnotations(annotations);
                }
                field.set(model, map);
            } else if (fieldType == List.class || fieldType == ObservableList.class) {
                Class[] genericTypes = ChronicleTools.getGenericTypes(field.getGenericType(), 1);
                List underlying = (List)field.get(model);
                if (underlying == null) {
                    underlying = Collections.synchronizedList(new ArrayList());
                }
                ListWrapper list = new ListWrapper(this, field.getName(), genericTypes[0], underlying, 1024);
                Annotation[] annotations = field.getAnnotations();
                if (annotations != null) {
                    list.setAnnotations(annotations);
                }
                field.set(model, list);
            } else if (fieldType == Set.class || fieldType == ObservableSet.class) {
                Class[] genericTypes = ChronicleTools.getGenericTypes(field.getGenericType(), 1);
                Set underlying = (Set)field.get(model);
                if (underlying == null) {
                    underlying = Collections.newSetFromMap(new ConcurrentHashMap());
                }
                SetWrapper set = new SetWrapper(this, field.getName(), genericTypes[0], underlying, 1024);
                Annotation[] annotations = field.getAnnotations();
                if (annotations != null) {
                    set.setAnnotations(annotations);
                }
                field.set(model, set);
            } else {
                LOGGER.info("Skipping field of type " + fieldType + " as this is not supported interface");
            }
        } else {
            LOGGER.info("Skipping field of type " + fieldType + " as injecting concrete classes is not supported");
        }
    }

    public void start() {
        this.start(-1L);
    }

    public void start(final long lastEvent) {
        switch (this.mode) {
            case MASTER: {
                this.excerpt = this.chronicle.createExcerpt();
                long size = this.excerpt.size();
                while (this.excerpt.index() < size && this.excerpt.nextIndex()) {
                    this.processNextEvent(this.excerpt.index() <= lastEvent);
                }
                for (Wrapper wrapper : this.wrappersArray) {
                    wrapper.notifyOff(false);
                    wrapper.inSync();
                }
                break;
            }
            case READ_ONLY: {
                if (this.updater == null) break;
                this.updater.submit(new Runnable(){

                    @Override
                    public void run() {
                        DataStore.this.excerpt = DataStore.this.chronicle.createExcerpt();
                        while (!DataStore.this.closed) {
                            boolean found = DataStore.this.excerpt.nextIndex();
                            if (found) {
                                DataStore.this.processNextEvent(DataStore.this.excerpt.index() <= lastEvent);
                                continue;
                            }
                            for (Wrapper wrapper : DataStore.this.wrappersArray) {
                                wrapper.notifyOff(false);
                                wrapper.inSync();
                            }
                        }
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown mode " + (Object)((Object)this.mode)));
            }
        }
    }

    boolean processNextEvent(boolean notifyOff) {
        assert (this.excerpt != null);
        String name = this.excerpt.readEnum(String.class);
        Wrapper wrapper = this.wrappers.get(name);
        if (wrapper == null) {
            return true;
        }
        wrapper.notifyOff(notifyOff);
        wrapper.onExcerpt(this.excerpt);
        this.excerpt.finish();
        return false;
    }

    public void startAtEnd() {
        this.start(this.chronicle.size() - 1L);
    }

    public void add(String name, Wrapper wrapper) {
        this.wrappers.put(name, wrapper);
        this.wrappersArray = this.wrappers.values().toArray(new Wrapper[this.wrappers.size()]);
    }

    @NotNull
    public Excerpt startExcerpt(int capacity, @NotNull String name) {
        this.checkStarted();
        assert (this.excerpt != null);
        this.excerpt.startExcerpt(capacity + 2 + name.length());
        this.excerpt.writeEnum(name);
        return this.excerpt;
    }

    private void checkStarted() {
        if (this.excerpt == null) {
            throw new AssertionError((Object)"Not start()ed");
        }
    }

    public boolean enumeratedClass(@NotNull Class eClass) {
        if (Comparable.class.isAssignableFrom(eClass) && (eClass.getModifiers() & 0x10) != 0) {
            return true;
        }
        if (ExcerptMarshallable.class.isAssignableFrom(eClass) || Externalizable.class.isAssignableFrom(eClass)) {
            return true;
        }
        return this.chronicle.getMarshaller(eClass) != null;
    }

    public void checkWritable() {
        if (!this.mode.writable) {
            throw new IllegalStateException("ModelModel=" + (Object)((Object)this.mode));
        }
    }

    public long events() {
        this.checkStarted();
        assert (this.excerpt != null);
        return this.excerpt.index() + 1L;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.updater != null) {
            this.updater.shutdown();
        }
        this.chronicle.close();
    }

    public boolean nextEvent() {
        assert (this.updater == null);
        assert (this.excerpt != null);
        if (this.excerpt.nextIndex()) {
            this.processNextEvent(false);
            return true;
        }
        return false;
    }
}

