/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericEnumMarshaller<E>
implements EnumeratedMarshaller<E> {
    @NotNull
    private final Class<E> classMarshaled;
    @Nullable
    private final Constructor<E> constructor;
    @Nullable
    private final Method valueOf;
    @NotNull
    private final Map<String, E> map;

    public GenericEnumMarshaller(@NotNull Class<E> classMarshaled, final int capacity) {
        this.classMarshaled = classMarshaled;
        Constructor<E> constructor = null;
        Method valueOf = null;
        try {
            valueOf = classMarshaled.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = classMarshaled.getConstructor(String.class);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException(classMarshaled + " doesn't have a valueOf(String) or a Constructor(String)");
            }
        }
        this.constructor = constructor;
        this.valueOf = valueOf;
        this.map = new LinkedHashMap<String, E>(capacity * 10 / 7, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, E> eldest) {
                return this.size() > capacity;
            }
        };
    }

    @Override
    @NotNull
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    public void write(@NotNull Excerpt excerpt, @Nullable E e) {
        excerpt.writeUTF(e == null ? null : e.toString());
    }

    @Override
    @Nullable
    public E read(@NotNull Excerpt excerpt) {
        String s = excerpt.readUTF();
        return s == null ? null : (E)this.valueOf(s);
    }

    private E valueOf(String s) {
        Object e = this.map.get(s);
        if (e == null) {
            try {
                if (this.constructor != null) {
                    e = this.constructor.newInstance(s);
                    this.map.put(s, e);
                } else {
                    assert (this.valueOf != null);
                    Object invoke = this.valueOf.invoke(null, s);
                    e = invoke;
                    this.map.put(s, e);
                }
            }
            catch (Exception t) {
                throw new AssertionError((Object)t.getCause());
            }
        }
        return e;
    }

    @Override
    public E parse(@NotNull Excerpt excerpt, @NotNull StopCharTester tester) {
        String s = excerpt.parseUTF(tester);
        return this.valueOf(s);
    }
}

