/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import com.higherfrequencytrading.chronicle.impl.MappedMemory;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;

public class IntIndexedChronicle
extends IndexedChronicle {
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public IntIndexedChronicle(String basePath) throws IOException {
        super(basePath);
    }

    public IntIndexedChronicle(String basePath, int dataBitSizeHint) throws IOException {
        super(basePath, dataBitSizeHint);
    }

    public IntIndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder) throws IOException {
        super(basePath, dataBitSizeHint, byteOrder);
    }

    @Override
    public long getIndexData(long indexId) {
        long indexOffset = indexId << this.indexBitSize();
        MappedMemory mappedMemory = this.acquireIndexBuffer(indexOffset);
        MappedByteBuffer indexBuffer = mappedMemory.buffer();
        int num = indexBuffer.getInt((int)(indexOffset & (long)this.indexLowMask));
        mappedMemory.release();
        return (long)num & 0xFFFFFFFFL;
    }

    @Override
    protected int indexBitSize() {
        return 2;
    }

    @Override
    public void setIndexData(long indexId, long indexData) {
        if (indexData >= 0x100000000L) {
            throw new IllegalStateException("Size of Chronicle too large > 4 GB");
        }
        long indexOffset = indexId << this.indexBitSize();
        MappedMemory mappedMemory = this.acquireIndexBuffer(indexOffset);
        MappedByteBuffer indexBuffer = mappedMemory.buffer();
        assert (indexData <= 0xFFFFFFFFL);
        indexBuffer.putInt((int)(indexOffset & (long)this.indexLowMask), (int)indexData);
        mappedMemory.release();
    }
}

