/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import com.higherfrequencytrading.chronicle.impl.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMarshaller
implements EnumeratedMarshaller<CharSequence> {
    private final StringBuilder reader = new StringBuilder();
    private final StringInterner interner;

    public StringMarshaller(StringInterner interner) {
        this.interner = interner;
    }

    @Override
    @NotNull
    public Class<CharSequence> classMarshaled() {
        return CharSequence.class;
    }

    @Override
    public void write(@NotNull Excerpt excerpt, CharSequence s) {
        excerpt.writeUTF(s);
    }

    @Override
    @Nullable
    public String read(@NotNull Excerpt excerpt) {
        if (excerpt.readUTF(this.reader)) {
            return this.builderToString();
        }
        return null;
    }

    private String builderToString() {
        return this.interner.intern(this.reader);
    }

    @Override
    public String parse(@NotNull Excerpt excerpt, @NotNull StopCharTester tester) {
        this.reader.setLength(0);
        excerpt.parseUTF(this.reader, tester);
        return this.builderToString();
    }
}

