/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.AbstractExcerpt;
import com.higherfrequencytrading.chronicle.impl.DirectChronicle;
import com.higherfrequencytrading.chronicle.impl.MappedMemory;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeExcerpt
extends AbstractExcerpt {
    @NotNull
    public static final Unsafe UNSAFE;
    private static final int BYTES_OFFSET;
    private MappedMemory mappedMemory;

    protected UnsafeExcerpt(DirectChronicle chronicle) {
        super(chronicle);
    }

    @Override
    protected void index0(long index, long startPosition, long endPosition) {
        this.index = index;
        this.startPosition = startPosition;
        MappedMemory.release(this.mappedMemory);
        this.mappedMemory = this.chronicle.acquireDataBuffer(startPosition);
        this.buffer = this.mappedMemory.buffer();
        long address = ((DirectBuffer)((Object)this.buffer)).address();
        this.start = this.position = address + (long)this.chronicle.positionInBuffer(startPosition);
        this.limit = address + (long)this.chronicle.positionInBuffer(endPosition - 1L) + 1L;
        assert (this.limit > this.start && this.position < this.limit && endPosition > startPosition);
    }

    @Override
    public byte readByte() {
        return UNSAFE.getByte(this.position++);
    }

    @Override
    public byte readByte(int offset) {
        return UNSAFE.getByte(this.start + (long)offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        UNSAFE.copyMemory(null, this.position, b, BYTES_OFFSET + off, len);
        this.position += (long)len;
    }

    @Override
    public short readShort() {
        short s = UNSAFE.getShort(this.position);
        this.position += 2L;
        return s;
    }

    @Override
    public short readShort(int offset) {
        return UNSAFE.getShort(this.start + (long)offset);
    }

    @Override
    public char readChar() {
        char ch = UNSAFE.getChar(this.position);
        this.position += 2L;
        return ch;
    }

    @Override
    public char readChar(int offset) {
        return UNSAFE.getChar(this.start + (long)offset);
    }

    @Override
    public int readInt() {
        int i = UNSAFE.getInt(this.position);
        this.position += 4L;
        return i;
    }

    @Override
    public int readInt(int offset) {
        return UNSAFE.getInt(this.start + (long)offset);
    }

    @Override
    public long readLong() {
        long l = UNSAFE.getLong(this.position);
        this.position += 8L;
        return l;
    }

    @Override
    public long readLong(int offset) {
        return UNSAFE.getLong(this.start + (long)offset);
    }

    @Override
    public float readFloat() {
        float f = UNSAFE.getFloat(this.position);
        this.position += 4L;
        return f;
    }

    @Override
    public float readFloat(int offset) {
        return UNSAFE.getFloat(this.start + (long)offset);
    }

    @Override
    public double readDouble() {
        double d = UNSAFE.getDouble(this.position);
        this.position += 8L;
        return d;
    }

    @Override
    public double readDouble(int offset) {
        return UNSAFE.getDouble(this.start + (long)offset);
    }

    @Override
    public void write(int b) {
        UNSAFE.putByte(this.position++, (byte)b);
    }

    @Override
    public void write(int offset, int b) {
        UNSAFE.putByte(this.start + (long)offset, (byte)b);
    }

    @Override
    public void write(int offset, @NotNull byte[] b) {
        UNSAFE.copyMemory(b, BYTES_OFFSET, null, this.position, b.length);
        this.position += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        UNSAFE.copyMemory(b, BYTES_OFFSET + off, null, this.position, len);
        this.position += (long)len;
    }

    @Override
    public void writeShort(int v) {
        UNSAFE.putShort(this.position, (short)v);
        this.position += 2L;
    }

    @Override
    public void writeShort(int offset, int v) {
        UNSAFE.putShort(this.start + (long)offset, (short)v);
    }

    @Override
    public void writeChar(int v) {
        UNSAFE.putChar(this.position, (char)v);
        this.position += 2L;
    }

    @Override
    public void writeChar(int offset, int v) {
        UNSAFE.putChar(this.start + (long)offset, (char)v);
    }

    @Override
    public void writeInt(int v) {
        UNSAFE.putInt(this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeInt(int offset, int v) {
        UNSAFE.putInt(this.start + (long)offset, v);
    }

    @Override
    public void writeLong(long v) {
        UNSAFE.putLong(this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeLong(int offset, long v) {
        UNSAFE.putLong(this.start + (long)offset, v);
    }

    @Override
    public void writeFloat(float v) {
        UNSAFE.putFloat(this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeFloat(int offset, float v) {
        UNSAFE.putFloat(this.start + (long)offset, v);
    }

    @Override
    public void writeDouble(double v) {
        UNSAFE.putDouble(this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeDouble(int offset, double v) {
        UNSAFE.putDouble(this.start + (long)offset, v);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IllegalArgumentException();
        }
        if (len > this.remaining()) {
            len = this.remaining();
        }
        UNSAFE.copyMemory(null, this.position, b, BYTES_OFFSET + off, len);
        this.position += (long)len;
        return len;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

