/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tcp.gw;

import com.higherfrequencytrading.chronicle.Excerpt;

public abstract class GatewayEntryReader {
    private final Excerpt excerpt;
    private final boolean targetReader;

    public GatewayEntryReader(Excerpt excerpt, boolean targetReader) {
        this.excerpt = excerpt;
        this.targetReader = targetReader;
    }

    public boolean readEntry() {
        if (!this.excerpt.nextIndex()) {
            return false;
        }
        long writeTimeMS = this.excerpt.readLong();
        long writeTimeNS = this.excerpt.readLong();
        int pos = this.excerpt.position();
        long readTimeNS = this.excerpt.readLong();
        if (this.targetReader && readTimeNS == 0L) {
            readTimeNS = System.nanoTime();
            this.excerpt.writeLong(pos, readTimeNS);
        }
        int length = this.excerpt.readInt24();
        char type = (char)this.excerpt.readUnsignedByte();
        this.onEntry(writeTimeMS, writeTimeNS, readTimeNS, length, type, this.excerpt);
        return true;
    }

    protected abstract void onEntry(long var1, long var3, long var5, int var7, char var8, Excerpt var9);
}

