/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tcp.gw;

import com.higherfrequencytrading.chronicle.Chronicle;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import com.higherfrequencytrading.chronicle.tcp.gw.GatewayEntryReader;
import com.higherfrequencytrading.chronicle.tcp.gw.GatewayEntryWriter;
import com.higherfrequencytrading.chronicle.tools.IOTools;
import com.higherfrequencytrading.chronicle.tools.WaitingRunnable;
import com.higherfrequencytrading.chronicle.tools.WaitingThread;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SocketGateway
implements WaitingRunnable,
Closeable {
    private final InetSocketAddress address;
    @NotNull
    private final Chronicle outbound;
    @NotNull
    private final Chronicle inbound;
    @NotNull
    private final GatewayEntryReader outboundReader;
    @NotNull
    private final GatewayEntryWriter inboundWriter;
    private final ByteBuffer bb = ByteBuffer.allocateDirect(0x100000);
    @Nullable
    private SocketChannel socket;
    private volatile boolean closed = false;
    @NotNull
    private volatile State state = State.PAUSING;
    private long pauseTimeout = System.currentTimeMillis() + 100L;

    public SocketGateway(InetSocketAddress address, @NotNull Chronicle outbound, @NotNull Chronicle inbound, @NotNull WaitingThread waitingThread) {
        this.address = address;
        this.outbound = outbound;
        this.inbound = inbound;
        Excerpt out = outbound.createExcerpt();
        out.index(out.size());
        this.outboundReader = new GatewayEntryReader(out, true){
            final ByteBuffer byteBuffer;
            {
                this.byteBuffer = ByteBuffer.allocateDirect(0x100000);
            }

            @Override
            protected void onEntry(long writeTimeNS, long writeTimeMS, long readTimeMS, int length, char type, @NotNull Excerpt excerpt) {
                if (type == 'X') {
                    return;
                }
                this.byteBuffer.position(0);
                this.byteBuffer.limit(length);
                excerpt.read(this.byteBuffer);
                this.byteBuffer.flip();
                try {
                    assert (SocketGateway.this.socket != null);
                    IOTools.writeAll(SocketGateway.this.socket, this.byteBuffer);
                }
                catch (IOException e) {
                    SocketGateway.this.inboundWriter.onException("Failed to write", e);
                }
            }
        };
        Excerpt in = inbound.createExcerpt();
        in.index(in.size());
        this.inboundWriter = new GatewayEntryWriter(in);
        waitingThread.add(this);
    }

    public static void main(String ... args) throws IOException {
        String outboundPath = args[0];
        String inboundPath = args[1];
        String hostname = args[2];
        int port = Integer.parseInt(args[3]);
        WaitingThread thread = new WaitingThread(1, "SocketGateway " + hostname + ":" + port, false);
        new SocketGateway(new InetSocketAddress(hostname, port), new IndexedChronicle(outboundPath), new IndexedChronicle(inboundPath), thread);
    }

    @Override
    public boolean run() throws IllegalStateException {
        if (this.closed) {
            this.closeAll();
            throw new IllegalStateException("closed");
        }
        try {
            switch (this.state) {
                case PAUSING: {
                    if (System.currentTimeMillis() > this.pauseTimeout) break;
                    this.state = State.CONNECTING;
                    break;
                }
                case CONNECTING: {
                    this.socket = SocketChannel.open();
                    this.socket.configureBlocking(false);
                    this.socket.socket().connect(this.address);
                    this.state = State.WAITING_FOR_CONNECTION;
                    break;
                }
                case WAITING_FOR_CONNECTION: {
                    assert (this.socket != null);
                    if (!this.socket.finishConnect()) break;
                    this.state = State.PROCESSING;
                    break;
                }
                case PROCESSING: {
                    this.bb.clear();
                    assert (this.socket != null);
                    if (this.socket.read(this.bb) < 0) {
                        return this.outboundReader.readEntry();
                    }
                    this.bb.flip();
                    Excerpt excerpt = this.inboundWriter.startExceprt(this.bb.remaining(), 'I');
                    excerpt.write(this.bb);
                    excerpt.finish();
                }
            }
        }
        catch (IOException e) {
            this.inboundWriter.onException("Failed while " + (Object)((Object)this.state), e);
            this.state = State.PAUSING;
            this.pauseTimeout = System.currentTimeMillis() + 5000L;
        }
        return false;
    }

    void closeAll() {
        this.closeSocket();
        this.outbound.close();
        this.inbound.close();
    }

    private void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    static enum State {
        PAUSING,
        CONNECTING,
        WAITING_FOR_CONNECTION,
        PROCESSING;

    }
}

