/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.ning.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.RetryHelper;
import com.hubspot.horizon.RetryStrategy;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class NingRetryHandler
implements RetryStrategy {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NingAsyncHttpClient-Retry-%d").build();
    private static final ScheduledExecutorService RETRY_EXECUTOR = Executors.newScheduledThreadPool(5, THREAD_FACTORY);
    private final AtomicReference<Runnable> retryRunnable = new AtomicReference();
    private final HttpRequest.Options options;
    private final AtomicInteger currentRetries;

    public NingRetryHandler(HttpRequest.Options options) {
        this.options = (HttpRequest.Options)Preconditions.checkNotNull((Object)options);
        this.currentRetries = new AtomicInteger();
    }

    public void setRetryRunnable(Runnable runnable) {
        this.retryRunnable.set((Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    public void retry() {
        RETRY_EXECUTOR.schedule(this.retryRunnable(), (long)this.computeBackoff(this.currentRetries.incrementAndGet()), TimeUnit.MILLISECONDS);
    }

    public boolean shouldRetry(HttpRequest request, HttpResponse response) {
        return this.retriesRemaining() && this.options.getRetryStrategy().shouldRetry(request, response);
    }

    public boolean shouldRetry(HttpRequest request, IOException exception) {
        return this.retriesRemaining() && this.options.getRetryStrategy().shouldRetry(request, exception);
    }

    private int computeBackoff(int retries) {
        return RetryHelper.computeBackoff((HttpRequest.Options)this.options, (int)retries);
    }

    private boolean retriesRemaining() {
        return this.currentRetries.get() < this.options.getMaxRetries();
    }

    private Runnable retryRunnable() {
        return (Runnable)Preconditions.checkNotNull((Object)this.retryRunnable.get());
    }
}

