/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.multipart;

import com.hubspot.horizon.shaded.com.ning.http.client.Param;
import com.hubspot.horizon.shaded.com.ning.http.client.multipart.CounterPartVisitor;
import com.hubspot.horizon.shaded.com.ning.http.client.multipart.OutputStreamPartVisitor;
import com.hubspot.horizon.shaded.com.ning.http.client.multipart.Part;
import com.hubspot.horizon.shaded.com.ning.http.client.multipart.PartVisitor;
import com.hubspot.horizon.shaded.com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class PartBase
implements Part {
    private final String name;
    private final String contentType;
    private final Charset charset;
    private final String transferEncoding;
    private final String contentId;
    private String dispositionType;
    private List<Param> customHeaders;

    public PartBase(String name, String contentType, Charset charset, String contentId) {
        this(name, contentType, charset, contentId, null);
    }

    public PartBase(String name, String contentType, Charset charset, String contentId, String transferEncoding) {
        this.name = name;
        this.contentType = contentType;
        this.charset = charset;
        this.contentId = contentId;
        this.transferEncoding = transferEncoding;
    }

    protected void visitStart(PartVisitor visitor, byte[] boundary) throws IOException {
        visitor.withBytes(EXTRA_BYTES);
        visitor.withBytes(boundary);
    }

    protected void visitDispositionHeader(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CONTENT_DISPOSITION_BYTES);
        visitor.withBytes(this.getDispositionType() != null ? this.getDispositionType().getBytes(StandardCharsets.US_ASCII) : FORM_DATA_DISPOSITION_TYPE_BYTES);
        if (this.getName() != null) {
            visitor.withBytes(NAME_BYTES);
            visitor.withByte((byte)34);
            visitor.withBytes(this.getName().getBytes(StandardCharsets.US_ASCII));
            visitor.withByte((byte)34);
        }
    }

    protected void visitContentTypeHeader(PartVisitor visitor) throws IOException {
        String contentType = this.getContentType();
        if (contentType != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TYPE_BYTES);
            visitor.withBytes(contentType.getBytes(StandardCharsets.US_ASCII));
            Charset charset = this.getCharset();
            if (charset != null) {
                visitor.withBytes(CHARSET_BYTES);
                visitor.withBytes(charset.name().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    protected void visitTransferEncodingHeader(PartVisitor visitor) throws IOException {
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TRANSFER_ENCODING_BYTES);
            visitor.withBytes(transferEncoding.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitContentIdHeader(PartVisitor visitor) throws IOException {
        String contentId = this.getContentId();
        if (contentId != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_ID_BYTES);
            visitor.withBytes(contentId.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitCustomHeaders(PartVisitor visitor) throws IOException {
        if (MiscUtils.isNonEmpty(this.customHeaders)) {
            for (Param param : this.customHeaders) {
                visitor.withBytes(CRLF_BYTES);
                visitor.withBytes(param.getName().getBytes(StandardCharsets.US_ASCII));
                visitor.withBytes(param.getValue().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    protected void visitEndOfHeaders(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CRLF_BYTES);
    }

    protected void visitEnd(PartVisitor visitor) throws IOException {
        visitor.withBytes(CRLF_BYTES);
    }

    protected abstract long getDataLength();

    protected abstract void sendData(OutputStream var1) throws IOException;

    @Override
    public void write(OutputStream out, byte[] boundary) throws IOException {
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(out);
        this.visitStart(visitor, boundary);
        this.visitDispositionHeader(visitor);
        this.visitContentTypeHeader(visitor);
        this.visitTransferEncodingHeader(visitor);
        this.visitContentIdHeader(visitor);
        this.visitCustomHeaders(visitor);
        this.visitEndOfHeaders(visitor);
        this.sendData(visitor.getOutputStream());
        this.visitEnd(visitor);
    }

    @Override
    public long length(byte[] boundary) {
        long dataLength = this.getDataLength();
        try {
            if (dataLength < 0L) {
                return -1L;
            }
            CounterPartVisitor visitor = new CounterPartVisitor();
            this.visitStart(visitor, boundary);
            this.visitDispositionHeader(visitor);
            this.visitContentTypeHeader(visitor);
            this.visitTransferEncodingHeader(visitor);
            this.visitContentIdHeader(visitor);
            this.visitCustomHeaders(visitor);
            this.visitEndOfHeaders(visitor);
            this.visitEnd(visitor);
            return dataLength + visitor.getCount();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while computing length, WTF", e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name=" + this.getName() + " contentType=" + this.getContentType() + " charset=" + this.getCharset() + " tranferEncoding=" + this.getTransferEncoding() + " contentId=" + this.getContentId() + " dispositionType=" + this.getDispositionType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getDispositionType() {
        return this.dispositionType;
    }

    public void setDispositionType(String dispositionType) {
        this.dispositionType = dispositionType;
    }

    public void addCustomHeader(String name, String value) {
        if (this.customHeaders == null) {
            this.customHeaders = new ArrayList<Param>(2);
        }
        this.customHeaders.add(new Param(name, value));
    }

    public void setCustomHeaders(List<Param> customHeaders) {
        this.customHeaders = customHeaders;
    }
}

