/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly;

import com.hubspot.horizon.shaded.com.ning.http.client.AsyncHandler;
import com.hubspot.horizon.shaded.com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.hubspot.horizon.shaded.com.ning.http.client.MaxRedirectException;
import com.hubspot.horizon.shaded.com.ning.http.client.ProxyServer;
import com.hubspot.horizon.shaded.com.ning.http.client.Realm;
import com.hubspot.horizon.shaded.com.ning.http.client.Request;
import com.hubspot.horizon.shaded.com.ning.http.client.RequestBuilder;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.CookieDecoder;
import com.hubspot.horizon.shaded.com.ning.http.client.filter.FilterContext;
import com.hubspot.horizon.shaded.com.ning.http.client.filter.ResponseFilter;
import com.hubspot.horizon.shaded.com.ning.http.client.listener.TransferCompletionHandler;
import com.hubspot.horizon.shaded.com.ning.http.client.ntlm.NTLMEngine;
import com.hubspot.horizon.shaded.com.ning.http.client.ntlm.NTLMEngineException;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.ConnectionManager;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseStatus;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.StatusHandler;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.Utils;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.events.ContinueEvent;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.events.GracefulCloseEvent;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.hubspot.horizon.shaded.com.ning.http.client.uri.Uri;
import com.hubspot.horizon.shaded.com.ning.http.client.ws.WebSocketUpgradeHandler;
import com.hubspot.horizon.shaded.com.ning.http.util.AsyncHttpProviderUtils;
import com.hubspot.horizon.shaded.com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpClientFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AhcEventFilter
extends HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AhcEventFilter.class);
    private static final Map<Integer, StatusHandler> HANDLER_MAP = new HashMap<Integer, StatusHandler>(8);
    private static IOException notKeepAliveReason;
    private final GrizzlyAsyncHttpProvider provider;

    AhcEventFilter(GrizzlyAsyncHttpProvider provider, int maxHerdersSizeProperty) {
        super(maxHerdersSizeProperty);
        this.provider = provider;
        HANDLER_MAP.put(HttpStatus.UNAUTHORIZED_401.getStatusCode(), AuthorizationHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.PROXY_AUTHENTICATION_REQUIRED_407.getStatusCode(), ProxyAuthorizationHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.MOVED_PERMANENTLY_301.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.FOUND_302.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.SEE_OTHER_303.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.TEMPORARY_REDIRECT_307.getStatusCode(), RedirectHandler.INSTANCE);
        HANDLER_MAP.put(HttpStatus.PERMANENT_REDIRECT_308.getStatusCode(), RedirectHandler.INSTANCE);
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == GracefulCloseEvent.class) {
            GracefulCloseEvent closeEvent = (GracefulCloseEvent)event;
            HttpResponsePacket response = closeEvent.getHttpTxContext().responsePacket;
            response.getProcessingState().getHttpContext().attach(ctx);
            this.onHttpPacketParsed((HttpHeader)response, ctx);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ctx.getCloseable().closeWithReason(Exceptions.makeIOException((Throwable)error));
    }

    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(content.getHttpHeader());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler != null && context.currentState != AsyncHandler.STATE.ABORT) {
            try {
                context.currentState = handler.onBodyPartReceived(new GrizzlyResponseBodyPart(content, ctx.getConnection()));
            }
            catch (Exception e) {
                handler.onThrowable(e);
            }
        }
    }

    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        AsyncHandler handler = context.getAsyncHandler();
        if (handler instanceof TransferCompletionHandler) {
            ((TransferCompletionHandler)handler).onHeaderWriteCompleted();
        }
    }

    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(content.getHttpHeader());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler instanceof TransferCompletionHandler) {
            int written = content.getContent().remaining();
            context.totalBodyWritten += (long)written;
            long total = context.totalBodyWritten;
            ((TransferCompletionHandler)handler).onContentWriteProgress(written, total, content.getHttpHeader().getContentLength());
        }
    }

    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        super.onInitialLineParsed(httpHeader, ctx);
        if (httpHeader.isSkipRemainder()) {
            return;
        }
        HttpResponsePacket responsePacket = (HttpResponsePacket)httpHeader;
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        int status = responsePacket.getStatus();
        if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(status)) {
            return;
        }
        if (HttpStatus.CONINTUE_100.statusMatches(status)) {
            ctx.notifyUpstream((FilterChainEvent)new ContinueEvent(context));
            return;
        }
        StatusHandler sh = context.statusHandler;
        context.statusHandler = null;
        if (sh != null && !sh.handlesStatus(status)) {
            context.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
        }
        boolean isRedirectAllowed = AhcEventFilter.isRedirectAllowed(context);
        if (context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE) {
            if (HANDLER_MAP.containsKey(status)) {
                context.statusHandler = HANDLER_MAP.get(status);
            }
            if (context.statusHandler instanceof RedirectHandler && !isRedirectAllowed) {
                context.statusHandler = null;
            }
        }
        if (isRedirectAllowed) {
            if (AhcEventFilter.isRedirect(status)) {
                if (context.statusHandler == null) {
                    context.statusHandler = RedirectHandler.INSTANCE;
                }
                ++context.redirectCount;
                if (AhcEventFilter.redirectCountExceeded(context)) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(new MaxRedirectException());
                }
            } else {
                context.redirectCount = 0;
            }
        }
        GrizzlyResponseStatus responseStatus = new GrizzlyResponseStatus(responsePacket, context.getAhcRequest().getUri(), this.provider.getClientConfig());
        context.responsePacket = responsePacket;
        context.responseStatus = responseStatus;
        if (context.statusHandler != null) {
            return;
        }
        if (context.currentState != AsyncHandler.STATE.ABORT) {
            try {
                AsyncHandler handler = context.getAsyncHandler();
                if (handler != null) {
                    context.currentState = handler.onStatusReceived(responseStatus);
                    if (context.isWSRequest && context.currentState == AsyncHandler.STATE.ABORT) {
                        httpHeader.setSkipRemainder(true);
                        try {
                            context.done(handler.onCompleted());
                        }
                        catch (Throwable e) {
                            context.abort(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                httpHeader.setSkipRemainder(true);
                context.abort(e);
            }
        }
    }

    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setSkipRemainder(true);
        HttpTransactionContext.currentTransaction(httpHeader).abort(t);
    }

    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setSkipRemainder(true);
        HttpTransactionContext.currentTransaction(httpHeader).abort(t);
    }

    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        block20: {
            boolean result;
            super.onHttpHeaderParsed(httpHeader, buffer, ctx);
            LOGGER.debug("RESPONSE: {}", (Object)httpHeader);
            if (httpHeader.isSkipRemainder()) {
                return false;
            }
            HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
            if (context.establishingTunnel) {
                httpHeader.setExpectContent(false);
                return false;
            }
            AsyncHandler handler = context.getAsyncHandler();
            List<ResponseFilter> filters = this.provider.getClientConfig().getResponseFilters();
            GrizzlyResponseHeaders responseHeaders = new GrizzlyResponseHeaders((HttpResponsePacket)httpHeader);
            if (!filters.isEmpty()) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(context.getAhcRequest()).responseHeaders(responseHeaders).responseStatus(context.responseStatus).build();
                try {
                    for (ResponseFilter f : filters) {
                        fc = f.filter(fc);
                    }
                }
                catch (Exception e) {
                    context.abort(e);
                }
                if (fc.replayRequest()) {
                    httpHeader.setSkipRemainder(true);
                    Request newRequest = fc.getRequest();
                    AsyncHandler newHandler = fc.getAsyncHandler();
                    try {
                        GrizzlyResponseFuture responseFuture = context.future;
                        ConnectionManager m = context.provider.getConnectionManager();
                        Connection c = m.openSync(newRequest);
                        HttpTransactionContext newContext = context.cloneAndStartTransactionFor(c, newRequest);
                        responseFuture.setAsyncHandler(newHandler);
                        responseFuture.setHttpTransactionCtx(newContext);
                        try {
                            this.provider.execute(newContext);
                        }
                        catch (IOException ioe) {
                            newContext.abort(ioe);
                        }
                    }
                    catch (Exception e) {
                        context.abort(e);
                    }
                    return false;
                }
            }
            if (context.statusHandler != null && context.invocationStatus == StatusHandler.InvocationStatus.CONTINUE && !(result = context.statusHandler.handleStatus((HttpResponsePacket)httpHeader, context, ctx))) {
                httpHeader.setSkipRemainder(true);
                return false;
            }
            if (context.isWSRequest) {
                try {
                    context.protocolHandler.setConnection(ctx.getConnection());
                    GrizzlyWebSocketAdapter webSocketAdapter = AhcEventFilter.createWebSocketAdapter(context);
                    context.webSocket = webSocketAdapter;
                    WebSocket ws = webSocketAdapter.getGrizzlyWebSocket();
                    if (context.currentState == AsyncHandler.STATE.UPGRADE) {
                        httpHeader.setChunked(false);
                        ws.onConnect();
                        WebSocketHolder.set((Connection)ctx.getConnection(), (ProtocolHandler)context.protocolHandler, (WebSocket)ws);
                        ((WebSocketUpgradeHandler)context.getAsyncHandler()).onSuccess(context.webSocket);
                        int wsTimeout = this.provider.getClientConfig().getWebSocketTimeout();
                        IdleTimeoutFilter.setCustomTimeout((Connection)ctx.getConnection(), (long)(wsTimeout <= 0 ? IdleTimeoutFilter.FOREVER : (long)wsTimeout), (TimeUnit)TimeUnit.MILLISECONDS);
                        context.done(handler.onCompleted());
                        break block20;
                    }
                    httpHeader.setSkipRemainder(true);
                    ((WebSocketUpgradeHandler)context.getAsyncHandler()).onClose(context.webSocket, 1002, "WebSocket protocol error: unexpected HTTP response status during handshake.");
                    context.done();
                }
                catch (Throwable e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            } else if (context.currentState != AsyncHandler.STATE.ABORT) {
                try {
                    context.currentState = handler.onHeadersReceived(responseHeaders);
                }
                catch (Exception e) {
                    httpHeader.setSkipRemainder(true);
                    context.abort(e);
                }
            }
        }
        return false;
    }

    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        boolean result = super.onHttpPacketParsed(httpHeader, ctx);
        if (httpHeader.isSkipRemainder()) {
            AhcEventFilter.cleanup(httpHeader.getProcessingState().getHttpContext());
            return result;
        }
        HttpTransactionContext context = HttpTransactionContext.currentTransaction(httpHeader);
        if (context.establishingTunnel && HttpStatus.OK_200.statusMatches(((HttpResponsePacket)httpHeader).getStatus())) {
            context.establishingTunnel = false;
            context.tunnelEstablished(connection);
            try {
                this.provider.execute(context);
                return result;
            }
            catch (IOException e) {
                context.abort(e);
                return result;
            }
        }
        AhcEventFilter.cleanup(httpHeader.getProcessingState().getHttpContext());
        AsyncHandler handler = context.getAsyncHandler();
        if (handler != null) {
            try {
                context.done(handler.onCompleted());
            }
            catch (Throwable e) {
                context.abort(e);
            }
        } else {
            context.done();
        }
        return result;
    }

    private static GrizzlyWebSocketAdapter createWebSocketAdapter(HttpTransactionContext context) {
        return GrizzlyWebSocketAdapter.newInstance(context.provider.getClientConfig().getAsyncHttpProviderConfig(), context.protocolHandler);
    }

    private static boolean isRedirectAllowed(HttpTransactionContext ctx) {
        Request r = ctx.getAhcRequest();
        return r.getFollowRedirect() != null ? r.getFollowRedirect() : ctx.redirectsAllowed;
    }

    private static void cleanup(final HttpContext httpContext) {
        HttpTransactionContext.cleanupTransaction(httpContext, (CompletionHandler<HttpTransactionContext>)new EmptyCompletionHandler<HttpTransactionContext>(){

            public void completed(HttpTransactionContext context) {
                if (!context.isReuseConnection()) {
                    Connection c = (Connection)httpContext.getCloseable();
                    if (!httpContext.getRequest().getProcessingState().isStayAlive()) {
                        if (notKeepAliveReason == null) {
                            notKeepAliveReason = new IOException("HTTP keep-alive was disabled for this connection");
                        }
                        c.closeWithReason(notKeepAliveReason);
                    } else {
                        ConnectionManager cm = context.provider.getConnectionManager();
                        cm.returnConnection(c);
                    }
                }
            }
        });
    }

    private static boolean redirectCountExceeded(HttpTransactionContext context) {
        return context.redirectCount > context.maxRedirectCount;
    }

    private static boolean isRedirect(int status) {
        return HttpStatus.MOVED_PERMANENTLY_301.statusMatches(status) || HttpStatus.FOUND_302.statusMatches(status) || HttpStatus.SEE_OTHER_303.statusMatches(status) || HttpStatus.TEMPORARY_REDIRECT_307.statusMatches(status) || HttpStatus.PERMANENT_REDIRECT_308.statusMatches(status);
    }

    private static Request newRequest(HttpTransactionContext ctx, Uri newUri, HttpResponsePacket response, Realm realm, boolean asGet) {
        Request prototype = ctx.getAhcRequest();
        FluentCaseInsensitiveStringsMap prototypeHeaders = prototype.getHeaders();
        prototypeHeaders.remove(Header.Host.toString());
        prototypeHeaders.remove(Header.ContentLength.toString());
        if (asGet) {
            prototypeHeaders.remove(Header.ContentType.toString());
        }
        if (realm != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
            prototypeHeaders.remove(Header.Authorization.toString());
            prototypeHeaders.remove(Header.ProxyAuthorization.toString());
        }
        RequestBuilder builder = new RequestBuilder(prototype);
        if (asGet) {
            builder.setMethod("GET");
        }
        builder.setUrl(newUri.toString());
        for (String cookieStr : response.getHeaders().values(Header.SetCookie)) {
            builder.addOrReplaceCookie(CookieDecoder.decode(cookieStr));
        }
        return builder.build();
    }

    private static Realm getRealm(HttpTransactionContext httpTransactionContext) {
        Realm realm = httpTransactionContext.getAhcRequest().getRealm();
        return realm != null ? realm : httpTransactionContext.provider.getClientConfig().getRealm();
    }

    private static Realm ntlmChallenge(Connection c, String wwwAuth, Request request, Realm realm, boolean proxyInd) throws NTLMEngineException {
        FluentCaseInsensitiveStringsMap headers = request.getHeaders();
        if (wwwAuth.equals("NTLM")) {
            String challengeHeader = NTLMEngine.INSTANCE.generateType1Msg();
            AhcEventFilter.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
        } else {
            AhcEventFilter.addType3NTLMAuthorizationHeader(wwwAuth, headers, realm, proxyInd);
            Utils.setNtlmEstablished(c);
        }
        return new Realm.RealmBuilder().clone(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
    }

    private static Realm ntlmProxyChallenge(Connection c, String wwwAuth, Request request, ProxyServer proxyServer) throws NTLMEngineException {
        FluentCaseInsensitiveStringsMap headers = request.getHeaders();
        headers.remove(Header.ProxyAuthorization.toString());
        Realm realm = proxyServer.realmBuilder().setScheme(Realm.AuthScheme.NTLM).setUri(request.getUri()).setMethodName(request.getMethod()).build();
        AhcEventFilter.addType3NTLMAuthorizationHeader(wwwAuth, headers, realm, true);
        Utils.setNtlmEstablished(c);
        return realm;
    }

    private static void addNTLMAuthorizationHeader(FluentCaseInsensitiveStringsMap headers, String challengeHeader, boolean proxyInd) {
        headers.add(AhcEventFilter.authorizationHeaderName(proxyInd), "NTLM " + challengeHeader);
    }

    private static void addType3NTLMAuthorizationHeader(String auth, FluentCaseInsensitiveStringsMap headers, Realm realm, boolean proxyInd) throws NTLMEngineException {
        headers.remove(AhcEventFilter.authorizationHeaderName(proxyInd));
        if (MiscUtils.isNonEmpty(auth) && auth.startsWith("NTLM ")) {
            String serverChallenge = auth.substring("NTLM ".length()).trim();
            String challengeHeader = NTLMEngine.INSTANCE.generateType3Msg(realm.getPrincipal(), realm.getPassword(), realm.getNtlmDomain(), realm.getNtlmHost(), serverChallenge);
            AhcEventFilter.addNTLMAuthorizationHeader(headers, challengeHeader, proxyInd);
        }
    }

    private static String authorizationHeaderName(boolean proxyInd) {
        return proxyInd ? Header.ProxyAuthorization.toString() : Header.Authorization.toString();
    }

    private static List<String> listOf(Iterable<String> values) {
        ArrayList<String> list = new ArrayList<String>(2);
        for (String value : values) {
            list.add(value);
        }
        return list;
    }

    private static final class RedirectHandler
    implements StatusHandler {
        static final RedirectHandler INSTANCE = new RedirectHandler();

        private RedirectHandler() {
        }

        @Override
        public boolean handlesStatus(int statusCode) {
            return AhcEventFilter.isRedirect(statusCode);
        }

        @Override
        public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
            Uri redirectUri;
            String redirectURL = responsePacket.getHeader(Header.Location);
            if (redirectURL == null) {
                throw new IllegalStateException("redirect received, but no location header was present");
            }
            Request req = httpTransactionContext.getAhcRequest();
            GrizzlyAsyncHttpProvider provider = httpTransactionContext.provider;
            Uri origUri = httpTransactionContext.lastRedirectUri == null ? req.getUri() : httpTransactionContext.lastRedirectUri;
            httpTransactionContext.lastRedirectUri = redirectUri = Uri.create(origUri, redirectURL);
            Request nextRequest = AhcEventFilter.newRequest(httpTransactionContext, redirectUri, responsePacket, AhcEventFilter.getRealm(httpTransactionContext), this.sendAsGet(responsePacket, httpTransactionContext));
            try {
                Connection c;
                responsePacket.setSkipRemainder(true);
                if (responsePacket.getProcessingState().isKeepAlive() && AsyncHttpProviderUtils.isSameHostAndProtocol(origUri, redirectUri)) {
                    c = ctx.getConnection();
                    httpTransactionContext.reuseConnection();
                } else {
                    ConnectionManager m = provider.getConnectionManager();
                    c = m.openSync(nextRequest);
                }
                HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, nextRequest);
                newContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                try {
                    provider.execute(newContext);
                }
                catch (IOException ioe) {
                    newContext.abort(ioe);
                }
                return false;
            }
            catch (Exception e) {
                httpTransactionContext.abort(e);
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.CONTINUE;
                return true;
            }
        }

        private boolean sendAsGet(HttpResponsePacket response, HttpTransactionContext ctx) {
            int statusCode = response.getStatus();
            return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !ctx.provider.getClientConfig().isStrict302Handling());
        }
    }

    private static final class ProxyAuthorizationHandler
    implements StatusHandler {
        static final ProxyAuthorizationHandler INSTANCE = new ProxyAuthorizationHandler();

        private ProxyAuthorizationHandler() {
        }

        @Override
        public boolean handlesStatus(int statusCode) {
            return HttpStatus.PROXY_AUTHENTICATION_REQUIRED_407.statusMatches(statusCode);
        }

        @Override
        public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
            List proxyAuthHeaders = AhcEventFilter.listOf(responsePacket.getHeaders().values(Header.ProxyAuthenticate));
            ProxyServer proxyServer = httpTransactionContext.getProxyServer();
            if (proxyAuthHeaders.isEmpty() || proxyServer == null) {
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                AsyncHandler ah = httpTransactionContext.getAsyncHandler();
                if (ah != null) {
                    try {
                        ah.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                }
                return true;
            }
            GrizzlyAsyncHttpProvider provider = httpTransactionContext.provider;
            Request req = httpTransactionContext.getAhcRequest();
            try {
                Connection c;
                Realm newRealm;
                String ntlmAuthenticate = AsyncHttpProviderUtils.getNTLM(proxyAuthHeaders);
                if (ntlmAuthenticate != null) {
                    newRealm = AhcEventFilter.ntlmProxyChallenge(ctx.getConnection(), ntlmAuthenticate, req, proxyServer);
                } else {
                    String firstAuthHeader = (String)proxyAuthHeaders.get(0);
                    newRealm = proxyServer.realmBuilder().setUri(req.getUri()).setOmitQuery(true).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseProxyAuthenticateHeader(firstAuthHeader).build();
                }
                responsePacket.setSkipRemainder(true);
                if (responsePacket.getProcessingState().isKeepAlive()) {
                    c = ctx.getConnection();
                    httpTransactionContext.reuseConnection();
                } else {
                    ConnectionManager m = provider.getConnectionManager();
                    c = m.openSync(req);
                }
                Request nextRequest = ((RequestBuilder)new RequestBuilder(req).setRealm(newRealm)).build();
                HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, nextRequest);
                newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                try {
                    provider.execute(newContext);
                }
                catch (IOException ioe) {
                    newContext.abort(ioe);
                }
            }
            catch (Exception e) {
                httpTransactionContext.abort(e);
            }
            return false;
        }
    }

    private static final class AuthorizationHandler
    implements StatusHandler {
        static final AuthorizationHandler INSTANCE = new AuthorizationHandler();

        private AuthorizationHandler() {
        }

        @Override
        public boolean handlesStatus(int statusCode) {
            return HttpStatus.UNAUTHORIZED_401.statusMatches(statusCode);
        }

        @Override
        public boolean handleStatus(HttpResponsePacket responsePacket, HttpTransactionContext httpTransactionContext, FilterChainContext ctx) {
            List authHeaders = AhcEventFilter.listOf(responsePacket.getHeaders().values(Header.WWWAuthenticate));
            Realm realm = AhcEventFilter.getRealm(httpTransactionContext);
            if (authHeaders.isEmpty() || realm == null) {
                httpTransactionContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                AsyncHandler ah = httpTransactionContext.getAsyncHandler();
                if (ah != null) {
                    try {
                        ah.onStatusReceived(httpTransactionContext.responseStatus);
                    }
                    catch (Exception e) {
                        httpTransactionContext.abort(e);
                    }
                }
                return true;
            }
            GrizzlyAsyncHttpProvider provider = httpTransactionContext.provider;
            Request req = httpTransactionContext.getAhcRequest();
            try {
                Connection c;
                boolean isContinueAuth;
                Realm newRealm;
                String ntlmAuthenticate = AsyncHttpProviderUtils.getNTLM(authHeaders);
                if (ntlmAuthenticate != null) {
                    Connection connection = ctx.getConnection();
                    newRealm = AhcEventFilter.ntlmChallenge(connection, ntlmAuthenticate, req, realm, false);
                    isContinueAuth = !Utils.isNtlmEstablished(connection);
                } else {
                    isContinueAuth = false;
                    String firstAuthHeader = (String)authHeaders.get(0);
                    newRealm = new Realm.RealmBuilder().clone(realm).setUri(req.getUri()).setMethodName(req.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(firstAuthHeader).build();
                }
                responsePacket.setSkipRemainder(true);
                if (responsePacket.getProcessingState().isKeepAlive()) {
                    c = ctx.getConnection();
                    httpTransactionContext.reuseConnection();
                } else {
                    ConnectionManager m = provider.getConnectionManager();
                    c = m.openSync(req);
                }
                Request nextRequest = ((RequestBuilder)new RequestBuilder(req).setRealm(newRealm)).build();
                HttpTransactionContext newContext = httpTransactionContext.cloneAndStartTransactionFor(c, nextRequest);
                if (!isContinueAuth) {
                    newContext.invocationStatus = StatusHandler.InvocationStatus.STOP;
                }
                try {
                    provider.execute(newContext);
                }
                catch (IOException ioe) {
                    newContext.abort(ioe);
                }
            }
            catch (Exception e) {
                httpTransactionContext.abort(e);
            }
            return false;
        }
    }
}

