/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly;

import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseHeaders;
import com.hubspot.horizon.shaded.com.ning.http.client.HttpResponseStatus;
import com.hubspot.horizon.shaded.com.ning.http.client.ResponseBase;
import com.hubspot.horizon.shaded.com.ning.http.client.cookie.Cookie;
import com.hubspot.horizon.shaded.com.ning.http.client.providers.grizzly.GrizzlyResponseBodyPart;
import com.hubspot.horizon.shaded.com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.CookiesBuilder;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.glassfish.grizzly.utils.Charsets;

public class GrizzlyResponse
extends ResponseBase {
    private final Buffer responseBody;
    private final HttpResponsePacket httpResponsePacket;

    public GrizzlyResponse(HttpResponsePacket httpResponsePacket, HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        super(status, headers, bodyParts);
        this.httpResponsePacket = httpResponsePacket;
        if (MiscUtils.isNonEmpty(bodyParts)) {
            if (bodyParts.size() == 1) {
                this.responseBody = ((GrizzlyResponseBodyPart)bodyParts.get(0)).getBodyBuffer();
            } else {
                Buffer firstBuffer = ((GrizzlyResponseBodyPart)bodyParts.get(0)).getBodyBuffer();
                MemoryManager mm = httpResponsePacket.getRequest().getConnection().getMemoryManager();
                Buffer constructedBodyBuffer = firstBuffer;
                int len = bodyParts.size();
                for (int i = 1; i < len; ++i) {
                    constructedBodyBuffer = Buffers.appendBuffers((MemoryManager)mm, (Buffer)constructedBodyBuffer, (Buffer)((GrizzlyResponseBodyPart)bodyParts.get(i)).getBodyBuffer());
                }
                this.responseBody = constructedBodyBuffer;
            }
        } else {
            this.responseBody = Buffers.EMPTY_BUFFER;
        }
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return new BufferInputStream(this.responseBody);
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
        int len = Math.min(this.responseBody.remaining(), maxLength);
        int pos = this.responseBody.position();
        return this.responseBody.toStringContent(this.getCharset(charset), pos, len + pos);
    }

    @Override
    public String getResponseBody(String charset) throws IOException {
        return this.responseBody.toStringContent(this.getCharset(charset));
    }

    @Override
    public String getResponseBodyExcerpt(int maxLength) throws IOException {
        return this.getResponseBodyExcerpt(maxLength, null);
    }

    @Override
    public String getResponseBody() throws IOException {
        return this.getResponseBody(null);
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        byte[] responseBodyBytes = new byte[this.responseBody.remaining()];
        int origPos = this.responseBody.position();
        this.responseBody.get(responseBodyBytes);
        this.responseBody.position(origPos);
        return responseBodyBytes;
    }

    @Override
    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
        return this.responseBody.toByteBuffer();
    }

    @Override
    protected List<Cookie> buildCookies() {
        Object values = this.headers.getHeaders().get("set-cookie");
        if (MiscUtils.isNonEmpty(values)) {
            CookiesBuilder.ServerCookiesBuilder builder = new CookiesBuilder.ServerCookiesBuilder(false, true);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String header = (String)iterator.next();
                builder.parse(header);
            }
            return this.convertCookies(builder.build());
        }
        return Collections.emptyList();
    }

    private List<Cookie> convertCookies(Cookies cookies) {
        org.glassfish.grizzly.http.Cookie[] grizzlyCookies = cookies.get();
        ArrayList<Cookie> convertedCookies = new ArrayList<Cookie>(grizzlyCookies.length);
        for (org.glassfish.grizzly.http.Cookie gCookie : grizzlyCookies) {
            convertedCookies.add(new Cookie(gCookie.getName(), gCookie.getValue(), false, gCookie.getDomain(), gCookie.getPath(), gCookie.getMaxAge(), gCookie.isSecure(), false));
        }
        return Collections.unmodifiableList(convertedCookies);
    }

    private Charset getCharset(String charset) {
        String charsetLocal = charset;
        if (charsetLocal == null) {
            charsetLocal = this.httpResponsePacket.getCharacterEncoding();
        }
        return charsetLocal == null ? Charsets.ASCII_CHARSET : Charsets.lookupCharset((String)charsetLocal);
    }
}

