/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.horizon.shaded.com.ning.http.client.providers.netty.request.body;

import com.hubspot.horizon.shaded.com.ning.http.client.Body;
import com.hubspot.horizon.shaded.com.ning.http.client.BodyGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FeedableBodyGenerator
implements BodyGenerator {
    private static final byte[] END_PADDING = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ZERO = "0".getBytes(StandardCharsets.US_ASCII);
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private FeedListener listener;
    private boolean writeChunkBoundaries = false;

    @Override
    public Body createBody() throws IOException {
        return new PushBody();
    }

    public void feed(ByteBuffer buffer, boolean isLast) throws IOException {
        this.queue.offer(new BodyPart(buffer, isLast));
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    public void setListener(FeedListener listener) {
        this.listener = listener;
    }

    public void writeChunkBoundaries() {
        this.writeChunkBoundaries = true;
    }

    private static final class BodyPart {
        private final boolean isLast;
        private final ByteBuffer buffer;

        public BodyPart(ByteBuffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }
    }

    public final class PushBody
    implements Body {
        private PushBodyState state = PushBodyState.ONGOING;

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public long read(ByteBuffer buffer) throws IOException {
            BodyPart nextPart = (BodyPart)FeedableBodyGenerator.this.queue.peek();
            if (nextPart == null) {
                switch (this.state) {
                    case ONGOING: {
                        return 0L;
                    }
                    case CLOSING: {
                        buffer.put(ZERO);
                        buffer.put(END_PADDING);
                        buffer.put(END_PADDING);
                        this.state = PushBodyState.FINISHED;
                        return buffer.position();
                    }
                    case FINISHED: {
                        return -1L;
                    }
                }
            }
            if (nextPart.buffer.remaining() == 0) {
                FeedableBodyGenerator.this.queue.remove();
                if (nextPart.isLast) {
                    this.state = FeedableBodyGenerator.this.writeChunkBoundaries ? PushBodyState.CLOSING : PushBodyState.FINISHED;
                }
                return this.read(buffer);
            }
            int capacity = buffer.remaining() - 10;
            int size = Math.min(nextPart.buffer.remaining(), capacity);
            if (size != 0) {
                if (FeedableBodyGenerator.this.writeChunkBoundaries) {
                    buffer.put(Integer.toHexString(size).getBytes(StandardCharsets.US_ASCII));
                    buffer.put(END_PADDING);
                }
                for (int i = 0; i < size; ++i) {
                    buffer.put(nextPart.buffer.get());
                }
                if (FeedableBodyGenerator.this.writeChunkBoundaries) {
                    buffer.put(END_PADDING);
                }
            }
            if (!nextPart.buffer.hasRemaining()) {
                if (nextPart.isLast) {
                    this.state = FeedableBodyGenerator.this.writeChunkBoundaries ? PushBodyState.CLOSING : PushBodyState.FINISHED;
                }
                FeedableBodyGenerator.this.queue.remove();
            }
            return size;
        }

        @Override
        public void close() {
        }
    }

    private static enum PushBodyState {
        ONGOING,
        CLOSING,
        FINISHED;

    }

    public static interface FeedListener {
        public void onContentAdded();
    }
}

